#ifdef WITH_GBA
#include <gba_types.h>
#else
#include <mygba.h>
#endif

void boxfilter(u16* dst, const u16* src)
{
	u32 r,g,b;
	u32 cc;
	int x,y,dx,dy;

	for(y=0;y<160;y++) {
	    for(x=0;x<240;x++) {
	        cc = r = g = b = 0;
            for(dy = -1;dy<=1;dy++) {
	            for(dx=-1;dx<=1;dx++) {
	                int nx = x+dx;
	                int ny = y+dy;
                    u16 ncolor;
                    if(nx < 0 || ny < 0 || nx >=240 || ny >= 160) continue;
                    ncolor = src[ny*240+nx];
                    cc++;
                    r+= (ncolor&0x001f);
                    g+= ((ncolor&0x03e0)>>5);
                    b+= ((ncolor&0x7c00)>>10);
                }
            }
            r = r/cc;
            g = g/cc;
            b = b/cc;

            dst[y*240+x] = (b<<10)+ (g<<5) + r;
        }
    }
}
