#!/bin/bash

model_type=$1
config="example_config/MIMIC-50/$model_type.yml"

echo "Running grid search on $config"
cd LibMultiLabel
echo "Removing logs from LibMultiLabel/runs/*$model_type*"
rm -rf runs/*${model_type}*

for seed in 1337 1331 42
do
    for num_filter_maps in 550 450 350 250 150 50
    do
        for filter_size in 10 8 6 4 2
        do
            for dropout in 0.8 0.6 0.4 0.2
            do
                for learning_rate in 0.0001 0.0003 0.001 0.003
                do
                    python3 main.py --config $config --seed $seed \
                                        --num_filter_per_size $num_filter_maps \
                                        --filter_sizes $filter_size \
                                        --dropout $dropout \
                                        --learning_rate $learning_rate
                done
                echo "Removing model_best.pt and model_last.pt from runs/*$model_type* ..."
                rm runs/*${model_type}*/*.pt
            done
        done
    done
done
