function make()
% This make.m is for MATLAB and OCTAVE under Windows, Mac, and Unix
Type = ver;
% This part is for OCTAVE
if(strcmp(Type(1).Name, 'Octave') == 1)
	blas_options ='-L/u/rofuyu/.local/lib -llapack_atlas -lf77blas -lcblas -latlas -lgfortran';
	blas_options ='-lblas -llapack';
	setenv('CXX', 'g++ ');
	setenv('DL_LD', 'g++ ');
	setenv('CXXFLAGS', '-fopenmp -ffast-math -pipe -O3 -DNDEBUG ');

	% grmf_train
	mex('-v', '-lgomp', blas_options, 'grmf_train.cpp', '../pmf.cpp', '../bilinear.cpp', '../imf.cpp');
	% imf_train
	mex('-v', '-lgomp', blas_options, 'imf_train.cpp', '../pmf.cpp', '../bilinear.cpp', '../imf.cpp');

% This part is for MATLAB
% remove -largeArrayDims on 32-bit machines of MATLAB
else
	verbose = '';
	largearray = '-largeArrayDims';

	if ispc() == 1,  % windows
		compflags = 'COMPFLAGS="$COMPFLAGS /openmp "';
		ldflags = 'LDFLAGS="$LDFLAGS /openmp "';
		cflags = 'CFLAGS="$CFLAGS /openmp "';
		cxxflags = 'CXXFLAGS="$CXXFLAGS /openmp "';

		coptim = 'OPTIMFLAGS="$OPTIMFLAGS /O2 /fp:fast /D_USE_FLOAT_"';
		cxxoptim = '';
		linkoptim = 'LDOPTIMFLAGS="$LDOPTIMFLAGS"';

		blaslib = fullfile(matlabroot,'extern','lib',computer('arch'),'microsoft','libmwblas.lib');
		lapacklib = fullfile(matlabroot,'extern','lib',computer('arch'),'microsoft','libmwlapack.lib');
	else
		compflags = 'COMPFLAGS="$COMPFLAGS -fopenmp -g "';
		ldflags = 'LDFLAGS="$LDFLAGS -fopenmp -g "';
		cflags = 'CFLAGS="$CFLAGS -fopenmp -I../ -g "';
		cxxflags = 'CXXFLAGS="$CXXFLAGS -fopenmp -I../ -g "';

		coptim = 'COPTIMFLAGS="$COPTIMFLAGS -O3 -DNDEBUG -march=native -ffast-math -D _USE_FLOAT_"';
		cxxoptim = 'CXXOPTIMFLAGS="$CXXOPTIMFLAGS -O3 -DNDEBUG -march=native -ffast-math -D _USE_FLOAT_"';
		coptim = 'COPTIMFLAGS="$COPTIMFLAGS -march=native -DNDEBUG -O3 -ffast-math "';
		cxxoptim = 'CXXOPTIMFLAGS="$CXXOPTIMFLAGS -march=native -DNDEBUG -O3 -ffast-math "';
		%coptim = 'COPTIMFLAGS="$COPTIMFLAGS -march=native -g "';
		%cxxoptim = 'CXXOPTIMFLAGS="$CXXOPTIMFLAGS -march=native -g "';
		%coptim = 'COPTIMFLAGS="$COPTIMFLAGS -D _USE_FLOAT_"';
		%cxxoptim = 'CXXOPTIMFLAGS="$CXXOPTIMFLAGS -D _USE_FLOAT_"';
		linkoptim = 'LDOPTIMFLAGS="$LDOPTIMFLAGS "';

		blaslib = '-lmwblas';
		lapacklib = '-lmwlapack';
	end
	% grmf_train
	mex(verbose, largearray, blaslib, lapacklib, compflags, cxxflags, cflags, ldflags, coptim, cxxoptim, linkoptim, ...
			'-cxx', 'grmf_train.cpp', '../pmf.cpp', '../bilinear.cpp', '../imf.cpp');
	% imf_train
	mex(verbose, largearray, blaslib, lapacklib, compflags, cxxflags, cflags, ldflags, coptim, cxxoptim, linkoptim, ...
			'-cxx', 'imf_train.cpp', '../pmf.cpp', '../bilinear.cpp', '../imf.cpp');
end


