addpath('data/')
addpath('grid_search/')
addpath('miscellaneous/')
addpath('Nystrom/')
addpath('unified-oneclass/matlab/')

load 'data/delicious.mat'
prob = add_bias(data);

display('leml')
imf_train(prob.Y, prob.X, [], prob.Yt, prob.Xt, [], ['-n 16 -t 7 -T 5 -g 20 -p 3 -s 11 -k ', num2str(300), ' -l ', num2str(2^-6), ' -r -1']);

display('square')
imf_train(prob.Y, prob.X, [], prob.Yt, prob.Xt, [], ['-n 16 -t 4 -T 5 -g 20 -p 3 -a -1 -s 11 -k ' , num2str(300),' -l ', num2str(2^-2), ' -r ', num2str(2^0)]);

display('logis')
imf_train(prob.Y, prob.X, [], prob.Yt, prob.Xt, [], ['-n 16 -t 4 -T 5 -g 20 -p 3 -a -1 -s 13 -k ', num2str(300), ' -l ', num2str(2^0), ' -r ', num2str(2^-3)]);

display('logis+nystrom')
tic
b = stdv(prob.X);
kernel = struct('type', 'rbf', 'para', b * 2^0);
[Ce, No] = INys(kernel, prob.X, 1000, 'k');
newX = [prob.X INys_apply(kernel, prob.X, Ce, No)];
newXt = [prob.Xt INys_apply(kernel, prob.Xt, Ce, No)];
Nystrom_time = toc
imf_train(prob.Y, newX, [], prob.Yt, newXt, [], ['-n 16 -t 14 -T 5 -g 20 -p 3 -a -1 -s 13 -k ', num2str(50), ' -l ', num2str(2^0), ' -r ', num2str(2^-3)]);

display('full logis')
imf_train(become_full(prob.Y), prob.X, [], prob.Yt, prob.Xt, [], ['-n 16 -t 7 -T 5 -g 20 -p 3 -a -1 -s 3 -k ', num2str(300), ' -l ', num2str(2^4), ' -r ', num2str(2^0)]);

display('sub logis')
imf_train(subsample(prob.Y, 2), prob.X, [], prob.Yt, prob.Xt, [], ['-n 16 -t 3 -T 5 -g 20 -p 3 -s 13 -k ', num2str(300), ' -l ', num2str(2^4), ' -r 0']);

display('sub square')
imf_train(subsample(prob.Y, 2), prob.X, [], prob.Yt, prob.Xt, [], ['-n 16 -t 3 -T 5 -g 20 -p 3 -s 11 -k ', num2str(300), ' -l ', num2str(2^4), ' -r 0']);
