function [] = run_nystrom(prob, K, CN)
	b = stdv(prob.X);

	for l = [-6, -4, -2, 0, 2, 4, 6]
		for r = [-9, -7, -5, -3, -1, 0]
			for g = [-1, 0, 1]
				kernel = struct('type', 'rbf', 'para', b * 2^g);
				[Ce, No] = INys(kernel, prob.X, CN, 'k');
				newX = [prob.X INys_apply(kernel, prob.X, Ce, No)];
				newXt = [prob.Xt INys_apply(kernel, prob.Xt, Ce, No)];

				disp(['log2l = ', num2str(l)])
				disp(['log2r = ', num2str(r)])
				disp(['log2g = ', num2str(g)])
				imf_train(prob.Y, newX, [], prob.Yt, newXt, [], ['-n 18 -t 15 -T 5 -g 20 -p 3 -a -1 -s 13 -k ', num2str(K), ' -l ', num2str(2^l), ' -r ', num2str(2^r)]);
			end
		end
	end
end
