import sys

if len(sys.argv) != 3:
    print("Usage: python grid_tool.py <measure> <filename>")
    exit(0)

measure = sys.argv[1]
fin = open(sys.argv[2], "r")

mx_perf = -1
line = fin.readline()

best_cnt = "1"

while line != "":
    line = line.strip("\n");

    if line.split(" ")[0] == "log2l":
        if mx_perf != -1:
            print ":", mx_perf, "(", best_cnt, ")"
        print "log2l = " + line.split(" ")[2],
        mx_perf = -1
    if line.split(" ")[0] == "log2r":
        print " log2r = " + line.split(" ")[2],
        mx_perf = -1
    if line.split(" ")[0] == "ratio":
        print " ratio = " + line.split(" ")[2],
        mx_perf = -1
    if line.split(" ")[0] == "log2lg":
        print " log2lg = " + line.split(" ")[2],
        mx_perf = -1
    if line.split(" ")[0] == "log2g":
        print " log2g = " + line.split(" ")[2],
        mx_perf = -1

    if line.split(" ")[0] == "IMF-iter":
        cnt = line.split(" ")[1];
        hit = 0
        perf = 0
        for token in line.split(" "):
            if token == "": continue
            if token == measure:
                hit = 1
                continue
            if hit:
                perf = float(token)
                break
        if mx_perf < perf:
            mx_perf = perf;
            best_cnt = cnt;

    line = fin.readline()

if mx_perf != -1:
    print ":", mx_perf, "(", best_cnt, ")"
