function newprob = get_val_MF(prob)
	one_idx = find(prob.Y);
	one_cnt = prod(size(one_idx));
	sel_idx = randsample(one_idx, int32(0.2 * one_cnt));

	disp('Finished sampling.')

	newprob = prob;

	disp('Copy problem.')

	[w, h] = size(prob.Yt);
	[I, J] = ind2sub([w, h], sel_idx);
	newprob.Yt = sparse(I, J, 1, w, h);

	disp('Modified Yt')

	newprob.Y = prob.Y - newprob.Yt;

	disp('Modified Y')
end
