% The following Matlab code is modified from
% <Improved Nystrom low-rank Approximation and Error Analysis> by Zhang and Kwok, ICML 2008

%Input:
% data: n-by-dim data matrix;
% kernel: (struct) kernel type and parameter
% center: the chosen centers in INys()
% normalizer: pinv(W)

function [newdata] = INys_apply(kernel, data, center, normalizer)

if(strcmp(kernel.type, 'pol') == 1);
    E = data * center';
    E = E.^kernel.para;
end;

if(strcmp(kernel.type, 'rbf') == 1);
    E = exp(-sqdist(data', center')/kernel.para);
end;

newdata= E * normalizer;
