% The following Matlab code is modified from
% <Improved Nystrom low-rank Approximation and Error Analysis> by Zhang and Kwok, ICML 2008

%Input:
% data: n-by-dim data matrix;
% m: number of landmark points;
% kernel: (struct) kernel type and parameter
% s: 'r' for random sampling and 'k' for k-means based sampling

function [center, normalizer] = INys(kernel, data, m, s)

[n,~] = size(data);

if(s == 'k')
    [~, center, m] = eff_kmeans(data, m, 5); %#iteration is restricted to 5
end

if(s == 'r')
   dex = randperm(n);
   center = data(dex(1:m),:);
end

if(strcmp(kernel.type, 'pol') == 1);
    W = center * center';
    W = W.^kernel.para;
end;

if(strcmp(kernel.type, 'rbf') == 1);
    W = exp(-sqdist(center', center')/kernel.para);
end;

[Ve, Va] = eig(full(W));
va = diag(Va);
pidx = find(va > 1e-6);
inVa = sparse(diag(va(pidx).^(-0.5)));

normalizer = Ve(:,pidx) * inVa;
