import os
import subprocess

runtest = ["liblr", "liblr-omp", "liblr-mkl", "liblr-rsb", "liblr-rsbXT"]
#runtest = ["liblinear-omp", "liblinear-omp1", "liblinear-omptest"]
coretest = {"liblr": [1], "liblr-omp": [1,2,4,6,8,10,12], "liblr-mkl" :[1,2,4,6,8,10,12], "liblr-rsb":[1,2,4,6,8,10,12], "liblr-rsbXT":[1,2,4,6,8,10,12]}
#dataset = ["rcv1_test.binary", "covtype.libsvm.binary.scale",  "leisure.scale", "SUSY", "webspam_wc_normalized_trigram.svm", "mnist8m.scale", "kddb"]
#dataset = ["rcv1_test.binary", "covtype.libsvm.binary.scale",  "leisure.scale", "SUSY", "webspam_wc_normalized_trigram.svm"]
dataset = ["heart_scale"]
dicC = {"heart_scale": "1", "rcv1_test.binary": "1", "covtype.libsvm.binary.scale": "1", "kddb": "0.1", "leisure.scale": "1", "SUSY": "1", "webspam_wc_normalized_trigram.svm": "1", "mnist8m.scale": "1"}

ROOT_PATH="../"
DATA_PATH="../liblr/"
#DATA_PATH="/home/faculty/cjlin/tmp/data/"
LOG_PATH=ROOT_PATH+"log/"
MOD_PATH=ROOT_PATH+"model/"
train="/train -s 0"
env_var = os.environ.copy()

def parse(data,run):
    logfile = LOG_PATH+data+"-"+run+".log"
    sumfile = LOG_PATH+data+"-"+run+"-sum.log"
    fl = open(logfile, "r")
    fl2 = open(sumfile, "w")
    Xvtime = 0.0
    Xviter = 0
    XTvtime = 0.0
    XTviter = 0
    trontime = 0.0
    traintime = 0.0
    constime = 0.0
    i = 0
    ct = coretest[run]
    for line in fl:
        sp = line.replace('\n', ' ')
        sp = sp.replace(',', ' ')
        sp = sp.split(' ')
        if sp[0] == "Xviter:":
            Xviter += int(sp[1])
            XTviter += int(sp[4])
        elif sp[0] == "Xvtime:":
            Xvtime += float(sp[1])
            XTvtime += float(sp[4])
        elif sp[0] == "Running" and Xviter != 0:
            fl2.write(str(ct[i])+" core:\n") 
            fl2.write("construct time: "+str(constime)+"\n")
            fl2.write("Xviter: "+ str(Xviter)+" "+"XTviter: " + str(XTviter)+"\n")
            fl2.write("Xvtime: "+ str(Xvtime)+" "+"XTvtime: " + str(XTvtime)+"\n")
            fl2.write("Xv+XTv runtime: "+str(Xvtime+XTvtime)+"\n")
            fl2.write("train time: "+str(traintime)+"\n")
            i += 1
            Xviter = 0; Xvtime = 0.0; XTviter = 0; XTvtime = 0.0; traintime = 0.0;
            trontime = 0.0
        elif sp[0] == "tron" and sp[1] == "runtime:":
            trontime += float(sp[2])
        elif sp[0] == "train":
            traintime += float(sp[3])
        elif sp[0] == "construct":
            constime = float(sp[2])
    fl2.write(str(ct[i])+" core:"+"\n")
    fl2.write("construct time: "+str(constime)+"\n")
    fl2.write("Xviter: "+ str(Xviter)+" "+"XTviter: " + str(XTviter)+"\n")
    fl2.write("Xvtime: "+ str(Xvtime)+" "+"XTvtime: " + str(XTvtime)+"\n")
    fl2.write("Xv+XTv runtime: "+str(Xvtime+XTvtime)+"\n")
    fl2.write("train time: "+str(traintime)+"\n")

'''
for data in dataset:
    for run in runtest:
        parse(data, run)
exit(0)
'''

for data in dataset:
    print("Running "+data)
    for run in runtest:
        if len(coretest[run]) == 0:
            continue
        print("Using "+run)
        filename = LOG_PATH+data+"-"+run+".log"
        if os.path.isfile(filename):
            continue;
        logfile = open(filename, "a", 0)
        logfile.write("*************************\n")
        logfile.write("Using "+run+"\n")
        for core in coretest[run]:

            print("running with "+str(core)+" cores:")
            env_var['OMP_NUM_THREADS'] = str(core)
            env_var['MKL_NUM_THREADS'] = str(core)
            env_var['MKL_DYNAMIC'] = "false"
            comd = ROOT_PATH+run+train+" -c "+dicC[data]+" "+DATA_PATH+data+" "+MOD_PATH+data+'-'+run+".model"+" >> "+filename
            print comd.split(' ')
            p = subprocess.Popen(comd.split(' '), stdout=subprocess.PIPE, env=env_var)

            logfile.write("-------------------------\n")
            logfile.write("Running "+data+"\n")
            logfile.write("-------------------------\n")
            logfile.write("running with "+str(core)+" cores\n")

            out, err = p.communicate()
            logfile.write(out)

        parse(data, run)
