/* 
 * Copyright (C) 1999-2000 Computer & Communications Research Laboratories,
 *				           Industrial Technology Research Institute
 * Copyright Telcordia Technologies 1999
 */
/*
 * utils.h
 */

#ifndef MGCUTILS_H
#define MGCUTILS_H

#include "mgcplib.h"

#define mgcMAXFIELD 100

#ifdef  __cplusplus
extern "C" {
#endif

/* Copy characters from src to dst, return number copied, dst[n]
 * until the first not in good 
 */
int mgcCpySpn(char* dst, char* src, char* good, int n);

/* Copy characters from src to dst, return number copied, dst[n] 
 * until the first in bad 
 */
int mgcCpyCSpn(char* dst, char* src, char* bad, int n);

/* remove whitespace from beginning and end of p, moving characters forward
 * returns p
 */
MGCP_API char* trimWS(char*p);

/* return string rep of integer i
 * string is in static memory, so it must be copied before another is
 * converted
 */
char* i2a(int i);

/*
 * attach string src to string dst
 */
char* stratt(char*dst,char*src);

#if defined(WIN32)&&!defined(bzero)
#define bzero(s, n)	memset(s, 0, n)
#endif

#ifdef  __cplusplus
}
#endif

#endif /* MGCUTILS_H */

