/* 
 * Copyright (C) 1999-2000 Computer & Communications Research Laboratories,
 *				           Industrial Technology Research Institute
 */
/*
 * trace.h
 */
#ifndef TRACE_H
#define TRACE_H

#include <stdio.h>

#define TRACE(x)   if(traceLevel>=(x)){
#define endTRACE(x) }

#define LOG2FILE(f, lbuf)	if (f!=NULL) \
								{fwrite(lbuf, strlen(lbuf), 1, f);fflush(f);}

#define LOG2SCREEN(lbuf)	printf("%s", lbuf)

#define PRINT(lbuf)	LOG2SCREEN(lbuf); \
					if (logFlag > 0) LOG2FILE(logfile, lbuf)

#define TRACE_BEGIN(fname)	logfile = fopen(fname,"w"); \
							if (logfile == NULL) { \
								printf("\nLog file %s open error.\n", fname); \
								fclose(logfile); \
							} \
							sprintf(logbuf, "*** start logging %s***\n", gettime()); \
							LOG2FILE(logfile, logbuf);

#define TRACE_END	if (logfile != NULL) { \
						sprintf(logbuf, "*** stop logging %s***\n", gettime()); \
						LOG2FILE(logfile, logbuf); \
						fclose(logfile);} 

static int traceLevel=0;
static int logFlag=0;
extern char logbuf[256];
extern FILE *logfile;

char* gettime(void);

#endif
