/*
 * msgToUI.h
 */
#ifndef MSGTOUI_H
#define MSGTOUI_H
#define TRUE 1
#define FALSE 0

typedef enum 
{ 
	Init=0, 
	Idle,
	Dialing,
	Connecting, 
	Ringing,
	Ringtone,
	Talking1,
	Talking2,
	Disconnect1,  /* someone hangup when talking*/
	Disconnect2,  /* someone hangup when ringing or ringtone*/
	Disconnect3,
	Disconnect,
	WaitReconnect,
	Reconnect
} stateType;

extern char StateType[14][15];
extern int epCount;
struct calldata  
{
	char* callId;
	char* caller;
	char* callee;
	int timeoutid;
	struct calldata* callernext;
	struct calldata* calleenext;
	stateType callflowState;
};
typedef struct calldata CALLDATA;

typedef struct 
{
// ep data
    char* phoneNum;
	char* gwHost;
	int	  gwPort;
	char* gwEndPointId;
    char* requestId;
    char* requestLine;
// ep status
    CALLDATA* call;				/* we current suppose each endpoint can creat only one call */
	CALLDATA* callhead;
	int timeoutid;
    struct CONNDATA* conn;
	char* localConnOpt;
	char* sdp;
	char* epTalkingto;
	stateType epState;
    int	isOnHook;
	int isBuzy;

	int proccessQ;
	struct MSGQ* msgQ;			/* use msgQ to save sent messages that didn't receive ACK yet */
	struct MSGQ* notifyQ;		/* use notifyQ to queue notify when CA is waiting for an ACK */
	int latestTId;				/* used to control call flow */
} EndPointData;

void msgtoUI(EndPointData* );
void OpenClientSocket(char* ,unsigned short );
void sendsocket(char* );
unsigned short UIport;
char *UIIP;

int StepByStep;
unsigned int conn_socket;
int isUIon;
#endif