/*
 * msgToUI.c
 */

#include "trace.h"
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include "msgToUI.h"
//////////////////////////////////////////////////////////open socketΨ쪺
#ifdef WIN32
	#define WIN32_LEAN_AND_MEAN
	#define _WSACleanup() WSACleanup()
	#define _WSAGetLastError() WSAGetLastError()
#else
	#include <sys/socket.h>
	#include <netinet/in.h>
	#include <netdb.h>
	#define _WSACleanup()
	#define _WSAGetLastError() -1
#endif

#include <malloc.h>
#include <Winsock.h>

#define MAX_CAM_PACKETSIZE		64	//max packet size for CA Monitor communicate with CA 
#define MSG_INTERVAL 200				// time interval between sending messages to CA

#define DEFAULT_PROTO SOCK_STREAM 
#define ATOI(s) ((s)? atoi(s): 0)

//////////////////////////////////////////////////////////////////////////

void msgtoUI(EndPointData* epd)
{
	char temp[MAX_CAM_PACKETSIZE];	
	char recvbuf[4];	
	char onhook[4];
	strcpy(temp,"phoneNum");
	strcat(temp,epd->phoneNum);
	sendsocket(temp);
	Sleep(MSG_INTERVAL);	

	if(epd->isOnHook)
		strcpy(onhook,"TRUE");
	else
		strcpy(onhook,"FALSE");
	strcpy(temp,"isOnHook");
	strcat(temp,onhook);
	sendsocket(temp);
	Sleep(MSG_INTERVAL);
	if(epd->epTalkingto && epd->isOnHook==0){		
		strcpy(temp,"epTalkingTo");
		strcat(temp,epd->epTalkingto);	
		sendsocket(temp);	
		Sleep(MSG_INTERVAL);		
	}else{
		strcpy(temp,"epTalkingTo");
		sendsocket(temp);
		Sleep(MSG_INTERVAL);		
	}
	

	strcpy(temp,"epState");
	strcat(temp,StateType[epd->epState]);	
    sendsocket(temp);
	Sleep(MSG_INTERVAL);		

	if(epd->call!=NULL){
		strcpy(temp,"CallFlowState");		
		strcat(temp,StateType[epd->call->callflowState]);
		sendsocket(temp);				
		Sleep(MSG_INTERVAL);
	}else{
		strcpy(temp,"CallFlowState");		
		sendsocket(temp);				
		Sleep(MSG_INTERVAL);
	}

	strcpy(recvbuf ,"    ");
	
	if(StepByStep==1){		
		printf("\nPress [Next] Button to Continue");
		recv(conn_socket, recvbuf, 4, 0);		
		printf("\n========================================\n");
	}
	
}


void OpenClientSocket(char* UIhost,unsigned short UIport)
{

char *server_name;
unsigned int addr;
int socket_type = DEFAULT_PROTO;
struct sockaddr_in server;
struct hostent *hp;

#ifdef WIN32
	WSADATA wsaData;
#endif

#ifdef WIN32
	if (WSAStartup(0x202,&wsaData) == SOCKET_ERROR) {
		fprintf(stderr,"WSAStartup failed with error %d\n",WSAGetLastError());
		WSACleanup();
		isUIon=FALSE;
		return;
	}
#endif

	server_name = strdup(UIhost);
	if (isalpha(*server_name)) {   /* server address is a name */
		hp = (struct hostent*) gethostbyname(server_name);
	} else  { /* Convert nnn.nnn address to a usable one */
		addr = inet_addr(server_name);
		hp = (struct hostent*) gethostbyaddr((char *)&addr,4,AF_INET);
	}

	if (hp == NULL ) {
		fprintf(stderr,"Client: Cannot resolve address [%s]: Error %d\n",
			server_name,_WSAGetLastError());
		_WSACleanup();
		isUIon=FALSE;
		exit(1);
	}

	memset(&server,0,sizeof(server));
	memcpy(&(server.sin_addr),hp->h_addr,hp->h_length);
	server.sin_family = hp->h_addrtype;
	server.sin_port = htons(UIport);

	conn_socket = socket(AF_INET,socket_type,0);
    printf("\nconn_socket=%d\n",conn_socket);

	if (conn_socket <0 ) {
		fprintf(stderr,"Client: Error Opening socket: Error %d\n", _WSAGetLastError());
		_WSACleanup();
		isUIon=FALSE;
		return;
	}
	printf("\nClient connecting to: %s\n",hp->h_name);


#ifdef WIN32
	if (connect(conn_socket,(struct sockaddr*)&server,sizeof(server)) == SOCKET_ERROR) {
#endif
#ifdef SOLARIS
	if (connect(conn_socket,(struct sockaddr*)&server,sizeof(server)) == -1) {
#endif
		fprintf(stderr,"connect() failed: %d\n",_WSAGetLastError());
		_WSACleanup();
		isUIon=FALSE;
		return;
	}
	isUIon=TRUE;
}

void sendsocket(char* input)
{	
	int retval;

	retval = send(conn_socket, input, (strlen(input)+1), 0);//TwO_n[1

#ifdef WIN32
	if (retval == SOCKET_ERROR) {
#endif
#ifdef SOLARIS
	if (retval == -1) {
#endif
		//_WSACleanup();
		return;
	}
}