/* 
 * Copyright (C) 1999-2000 Computer & Communications Research Laboratories,
 *				           Industrial Technology Research Institute
 * Copyright Telcordia Technologies 1999
 */
/*
 * mgcStr.h
 */

#ifndef MGCSTR_H
#define MGCSTR_H

#include "mgcplib.h"

typedef struct mgcStrObj *mgcStr;

#ifdef  __cplusplus
extern "C" {
#endif

MGCP_API mgcStr mgcStrNew(void);			/* allocate a new String */
MGCP_API int  mgcStrLen(mgcStr);			/* length of string */
MGCP_API void mgcStrClr(mgcStr);	        /* set String to "" */
MGCP_API void mgcStrFree(mgcStr);			/* De-allocate String */
MGCP_API void mgcStrCat(mgcStr, char*);		/* Append second arg to String */
MGCP_API void mgcStrCatN(mgcStr, char*, int);	/* Append N character to String */
MGCP_API char*mgcStrAsCStr(mgcStr);			/* return char* version of String */
/* WARNING: mgcStrAsCStr does NOT return a copy.  That is the callers responsibility */

#ifdef  __cplusplus
}
#endif

#define MINALLOC    200

#endif /* MGCSTR_H */
