/* 
 * Copyright (C) 1999-2000 Computer & Communications Research Laboratories,
 *				           Industrial Technology Research Institute
 * Copyright Telcordia Technologies 1999
 */
/*
 * mgcSock.h
 */

#ifndef MGCSOCK_H
#define MGCSOCK_H

#define mgcMAXBUFLEN  10000

#include "mgcStr.h"
#include "mgcplib.h"

typedef struct mgcSockAddrObj* mgcSockAddr;

#ifdef  __cplusplus
extern "C" {
#endif

#ifdef WIN32
MGCP_API void initSockLib();
MGCP_API void cleanSock();
#endif

/* create new socket with addr domain:port 
 * domain == NULL means use my IP address
 */
MGCP_API mgcSockAddr	mgcSockAddrNewDom(char* domain, int port);

/* Return copy of _this
 * does not copy the domain (leaves as NULL)
 */
MGCP_API mgcSockAddr	mgcSockAddrDup(mgcSockAddr);

/* bind this_ to fd, return fd on success, -1 on error */
MGCP_API int		mgcSockAddrBind(mgcSockAddr, int fd);

/* Send String to this_ on socket fd, return -1 on error, 0 on OK */
MGCP_API int		mgcSockAddrSendTo(mgcSockAddr, int fd, mgcStr);

/* Receive next String on fd (which must be a socket)
 * Return new mgcSockAddr if successful, NULL otherwise
 * NB the caller is responsible for the mgcSockAddr returned
 * NB the caller must pass in a mgcStr that has been initialized
 * NB The mgcSockAddr returned has domain==NULL.  We do not do reverse DNS.
 */
MGCP_API mgcSockAddr	mgcSockAddrRecvFrom(int fd, mgcStr);

/* Free this_ */
MGCP_API void		mgcSockAddrFree(mgcSockAddr);

MGCP_API char*		mgcSockAddrGetDomain(mgcSockAddr);
/********************     SOCKETS     *************************/
/* Sockets are represented by file descriptors.  They may be freed by
   calling close */

/* Create a new socket, returning file descriptor, or -1 on error */
MGCP_API int mgcSockNew(void);

#ifdef  __cplusplus
}
#endif

#endif /* MGCSOCK_H */
