/* 
 * Copyright (C) 1999-2000 Computer & Communications Research Laboratories,
 *				           Industrial Technology Research Institute
 * Copyright Telcordia Technologies 1999
 */
/*
 * mgcp.h
 */

#ifndef MGCP_H
#define MGCP_H

#define NI(s)     printf(#s " not implemented*****\n\n")

#ifdef SOLARIS
#include <sys/time.h>
typedef int SOCKET;
#endif
#ifdef WIN32
#include <time.h>
#endif

typedef int (*mgcCallBack)(void*);

#define mgcPROTOCOL   "MGCP 1.0"

#define MGCP_PORT		2427
#define MGCP_PORT_GW	2427
#define MGCP_PORT_CA	2727

#include "mgcMsg.h"
#include "mgcAck.h"
#include "mgcLoop.h"
#include "mgcSock.h"
#include "mgcAlarm.h"
#include "mgcHash.h"
#include "mgcStr.h"
#include "utils.h"

/* CODING STANDARDS
 *
 ***** Abbreviations
 *** VERBS
 * Notif	Notify/Notification
 * Req		Request
 * Creat	Create
 * Mod		Modify
 * Del		Delete
 * Audit	Audit
 * Config	Configuration
 *
 *** NOUNS
 * Ack		Acknowledgement
 * Addr		Socket Address
 * Conn		Connection
 * EPt		Endpoint
 * Msg		Messages
 * Parm		Parameter(s)
 * TId		Transaction Id
 *
 *
 ***** Operations
 * New		Create a new instance of an object
 * Free		Destroy an instance of an object (frees all component parts)
 *			No ref counts, so make sure all pointers to object are gone
 * AsStr	Return a Str representing the object
 * AsCStr	Return a char* representing the object
 * Parse	Copies string into object and sets all fields
 *
 * Set		Assign field value (copies string)
 * Get		Return field value (returns pointer to space local to object)
 * Clr		Reset to initial conditions (empty, zero, ... )
 * Cat		Concatenate strings (append)
 *
 *
 ***** Object Types
 *	These object types have corresponding headers mgc***.h and 
 *	standard operations defined (as above).
 * Ack		Acknowledgement(Response)
 * Alarm	Alarms for scheduling events
 * Hash		Hash tables
 * Loop		Event loop for receiving incoming messages
 * Msg		Messages(Command)
 * Sock		Sockets for essablishing UDP communication
 * Str		Long Strings
 *
 *
 *
 * CODING PRACTICES
 * Strings passed as parameters are copied by the receiving function.
 * Strings returned are not copied and belong to the called function.
 *
 *
 */

#endif /* MGCP_H */
