/* 
 * Copyright (C) 1999-2000 Computer & Communications Research Laboratories,
 *				           Industrial Technology Research Institute
 * Copyright Telcordia Technologies 1999
 */
/*
 * mgcMsg.h
 */

#ifndef MGCMSG_H
#define MGCMSG_H

#include "mgcSock.h"
#include "mgcplib.h"

/* Basic Message Methods */
typedef enum 
{ 
	mgcEPtConfig=0, 
	mgcCreatConn,
	mgcModConn,
	mgcDelConn, 
	mgcNotifReq, 
	mgcNotify,
	mgcAuditEPt,
	mgcAuditConn,
	mgcRstrInPrgs,
	mgcUnknown
} mgcMsgType;
/* last enum must be mgcUnknown */

typedef struct mgcMsgObj	*mgcMsg;
typedef char				*mgcParmType;
typedef char				*mgcParmStr;

char* msgGetDomain(mgcMsg);

#ifdef  __cplusplus
extern "C" {
#endif

MGCP_API char*		mgcMsgVerb[];
MGCP_API mgcMsg		mgcMsgNew(mgcMsgType);
MGCP_API mgcMsgType	mgcMsgGetType(mgcMsg);
MGCP_API void		mgcMsgSetAddr(mgcMsg,mgcSockAddr);
MGCP_API mgcSockAddr	mgcMsgGetAddr(mgcMsg);
MGCP_API void		mgcMsgSetTId(mgcMsg, char*);
MGCP_API char*		mgcMsgGetTId(mgcMsg);
MGCP_API void		mgcMsgSetEPt(mgcMsg, char*);
MGCP_API char*		mgcMsgGetEPt(mgcMsg);
MGCP_API void		mgcMsgFree(mgcMsg);
MGCP_API void		mgcMsgParse(mgcMsg, char*);
MGCP_API mgcStr		mgcMsgAsStr(mgcMsg);
MGCP_API void		mgcMsgClr(mgcMsg);
MGCP_API void		mgcMsgAddParm(mgcMsg, mgcParmType, mgcParmStr);
MGCP_API mgcParmStr	mgcMsgGetParm(mgcMsg, mgcParmType);
MGCP_API void		mgcMsgSetSDP(mgcMsg, char*);
MGCP_API char*		mgcMsgGetSDP(mgcMsg);

//sjtsai: MGCP_API void		mgcMsgSend(mgcMsg, mgcSockAddr, int fd, mgcCallBack ackCallback);

#ifdef  __cplusplus
}
#endif

#endif /* MGCMSG_H */
