/* 
 * Copyright (C) 1999-2000 Computer & Communications Research Laboratories,
 *				           Industrial Technology Research Institute
 * Copyright Telcordia Technologies 1999
 */
/*
 * mgcLoop.h
 */

#ifndef MGCLOOP_H
#define MGCLOOP_H

#ifdef WIN32
#include <Winsock.h>
#endif
#ifdef SOLARIS
#include <sys/socket.h>
#endif

#include "mgcplib.h"

struct mgcExtEvents 
{
    SOCKET fd;
    int (*cb)(SOCKET);
};

#ifdef  __cplusplus
extern "C" {
#endif

/* >>> is msgEntity really a global type?
 * also need definitions of these functions
 */
typedef struct MsgToResend *msgEntity;

MGCP_API void mgcMsgSend(mgcMsg, mgcSockAddr);

MGCP_API void mgcAckSend(mgcAck, mgcSockAddr);

MGCP_API void mgcMsgDelonAck(mgcAck, mgcSockAddr);

MGCP_API void mgcInit(void);

/* set initial delay between resends of requests (usecs) */
MGCP_API void mgcLoopSetDelay(int);

/* mgcLoop(port, msgCB, ackCB, events, timeOut, timeOutCB)
 * Listens to port for MGCP requests and responses (MGCP_PORT, if zero)
 * Invokes reqCB and ackCB respectively, with pointer to the message 
 * or acknowledgement.  CallBack assumes responsibility for Msg/Ack,
 * including freeing memory.
 *
 * Also listens to members of events, which is a list of 
 *     file descriptor/callback pairs (null cb terminates list).
 * Invokes callback(fd)
 *
 * Wait times out every timeOut seconds 
 *     NULL    =>  never timeout
 *     {0,0}   =>  constant polling
 * On timeout, calls timeOutCB().
 *
 * 
 * If any callback returns non-zero, loop exits.
 */
MGCP_API int  mgcLoop(int port, int(*msgCB)(mgcMsg), int(*ackCB)(mgcAck),
	     struct mgcExtEvents events[],
	     struct timeval *timeOut, int(*timeOutCB)(void) );

/* mgcDupMsgCB is called when a duplicate message is received.
 * default value reports the duplicate.
 * set to NULL if no message is desired.
 */
extern MGCP_API void (*mgcDupMsgCB)(mgcMsg,mgcAck);

/* This is the socket used for sending and receiving messages in mgcLoop */
extern MGCP_API SOCKET mgcLoopSockFD;

#ifdef  __cplusplus
}
#endif

#endif /* MGC_LOOP_H */
