/* 
 * Copyright (C) 1999-2000 Computer & Communications Research Laboratories,
 *				           Industrial Technology Research Institute
 * Copyright Telcordia Technologies 1999
 */
/*
 * mgcHash.h
 */

#ifndef MGCHASH_H
#define MGCHASH_H

#include "mgcplib.h"

typedef struct mgcHashObj *mgcHash;
typedef enum 
{
	MGCHASH_POINTER=10, 
	MGCHASH_CSTRING, 
	MGCHASH_INT
} mgcHashType;

#ifdef  __cplusplus
extern "C" {
#endif

/* create new hashtable
 * initSize = number of entries in table (may grow)
 * keysUpper: bool should keys be mapped to upper case
 * strings: mgcHashType   should val be copied (cstrings and ints)
 *                 by mgcHashAdd
 * keys are always strings and always copied
 */
MGCP_API mgcHash mgcHashNew(int initSize, int keysUpper, mgcHashType  strings);

/* destroy hashtable, call freeVal on each val */
MGCP_API void mgcHashFree(mgcHash, void (*freeVal)(void*));

/* add pair key/val to hash, return old value */
MGCP_API void*	mgcHashAdd(mgcHash, char* key, void* val);

/* del key from hash, return old value */
MGCP_API void*	mgcHashDel(mgcHash, char* key);

/* return val for key in hash.  NULL if not found. */
MGCP_API void*	mgcHashItem(mgcHash, char* key);

/* iterator over keys in hash.  mgcNextKeys returns NULL when no keys left. */
MGCP_API void	mgcStartKeys(mgcHash);
MGCP_API char*	mgcNextKeys(mgcHash);

MGCP_API int     mgcHashSize(mgcHash);

#ifdef  __cplusplus
}
#endif

#endif /* MGCHASH_H */
