/* 
 * Copyright (C) 1999-2000 Computer & Communications Research Laboratories,
 *				           Industrial Technology Research Institute
 * Copyright Telcordia Technologies 1999
 */
/*
 * mgcAlarm.h
 */

#ifndef MGCALARM_H
#define MGCALARM_H

#ifdef SOLARIS
#include <stdlib.h>
#include <sys/time.h>
#endif

#ifdef WIN32
#define _WIN32_WINNT	0x400
#include<stdio.h>
#include<time.h>
#include<string.h>
#include<math.h>
#include<dos.h>
#include <windows.h>
#include<sys\timeb.h>
#endif

#ifdef SOLARIS
#include <signal.h>
#endif

#include "mgcplib.h"

#ifdef  __cplusplus
extern "C" {
#endif

/* MUST be called before any other mgcAlarm routines.
 * Allocates room for maxevents events waiting at one time.
 */
MGCP_API void mgcAlarmInit(int maxEvents);


typedef void (*mgcAlarmCB)(void*);

/* create an alarm to occur after delay.  On the alarm, call cb(data).
 * Returns an alarm id used by mgcAlarmDel to cancel an alarm.
 *
 * data is the responsibility of the creator of the alarm.  
 * It must either be deallocated by cb or when the event is deleted with
 * mgcAlarmDel
 */
MGCP_API int mgcAlarmSet(struct timeval delay, mgcAlarmCB cb, void* data);

/* Remove alarm e from future events.  
 * Returns associated data, in case it needs to be managed
 */
MGCP_API void *mgcAlarmDel(int e);

/* block/release occurrences of alarm.  
 * these are cumulative and may be nested 
 */
#ifdef SOLARIS
MGCP_API void mgcAlarmHold();
MGCP_API void mgcAlarmRelease();
#endif

#ifdef  __cplusplus
}
#endif

#endif /* MGCALARM_H */