/* 
 * Copyright (C) 1999-2000 Computer & Communications Research Laboratories,
 *				           Industrial Technology Research Institute
 * Copyright Telcordia Technologies 1999
 */
/*
 * mgcAck.h
 */

#ifndef MGCACK_H
#define MGCACK_H

#include "mgcplib.h"

/* Basic Acknowledgement methods */
typedef struct mgcAckObj	*mgcAck;

typedef enum  
{
    mgcAckUnknown		= 0,
	/* 100-199 provisional response */
	mgcAckExec			= 100,
	/* 200-299 successful completion */
    mgcAckOK			= 200,
    mgcAckConnDel		= 250,
	/* 400-499 transient error */
    mgcAckTransErr		= 400,
    mgcAckOffHook		= 401,
    mgcAckOnHook		= 402,
	mgcAckEPtFullNow	= 403,
	mgcAckBWFullNow		= 404,
	/* 500-599 permanent error */
    mgcAckEPtUnkn		= 500,
    mgcAckEPtNRdy		= 501,
    mgcAckEPtFull		= 502,
    mgcAckProtoErr		= 510,
    mgcAckBadExt		= 511,
    mgcAckNDetect		= 512,
    mgcAckNGen			= 513,
    mgcAckNSend			= 514,
    mgcAckBadConn		= 515,
	mgcAckCallUnkn		= 516,
	mgcAckModeUnkn		= 517,
	mgcAckPkgUnKn		= 518,
	mgcAckDMapNull		= 519,
	mgcAckEPtRstr		= 520,
	mgcAckEPtRdrct		= 521,
	mgcAckEvtUnkn		= 522,
	mgcAckActUnkn		= 523,
	mgcAckBadLConn		= 524,
	mgcAckLConnUnkn		= 525,
	mgcAckBWFull		= 526,
	mgcAckRConnErr		= 527,
	mgcAckProtoNMatch	= 528,
	mgcAckHWErr			= 529,
	mgcAckCASProtoErr	= 530,
	mgcAckTrunkErr		= 531
} mgcAckType;

#ifdef  __cplusplus
extern "C" {
#endif
	
MGCP_API mgcAck		mgcAckNew(mgcAckType);
MGCP_API void		mgcAckClr(mgcAck);
MGCP_API void		mgcAckSetType(mgcAck, mgcAckType);
MGCP_API mgcAckType	mgcAckGetType(mgcAck);
MGCP_API void		mgcAckSetTId(mgcAck, char*);
MGCP_API char*		mgcAckGetTId(mgcAck);
MGCP_API void		mgcAckSetAddr(mgcAck, mgcSockAddr);
MGCP_API mgcSockAddr	mgcAckGetAddr(mgcAck);
MGCP_API void		mgcAckFree(mgcAck);
MGCP_API void		mgcAckParse(mgcAck, char*);
MGCP_API mgcStr		mgcAckAsStr(mgcAck);
MGCP_API void		mgcAckAddParm(mgcAck, mgcParmType, mgcParmStr);
MGCP_API mgcParmStr	mgcAckGetParm(mgcAck, mgcParmType);
MGCP_API void		mgcAckSetSDP(mgcAck, char*);
MGCP_API char*		mgcAckGetSDP(mgcAck);

#ifdef  __cplusplus
}
#endif

#endif /* MGCACK_H */
