/* 
 * Copyright (C) 1999-2000 Computer & Communications Research Laboratories,
 *				           Industrial Technology Research Institute
 */
/*
 * CASim.h
 */
#ifndef CASIM_H
#define CASIM_H

#define MAXLINE 512
#define ATOI(s) ((s)? atoi(s): 0)

#include "msgToUI.h"

/* Use this queue to save transmitted message*/
struct MSGDATA 
{  
	int tid;
    char* m;
	char* ack;
    struct MSGDATA* next;
};

struct MSGQ
{
	struct MSGDATA* headQ;
	struct MSGDATA* tailQ;
	int sizeQ;
};

static void enterMSGQ(struct MSGQ*,mgcMsg);
static struct MSGDATA* leaveMSGQ(struct MSGQ*);
mgcMsg setAckMSGQ(struct MSGQ*,mgcAck ack);
void freeMSGDATA(struct MSGDATA*);

char StateType[14][15] = 
{
	"Init\0", 
	"Idle\0",
	"Dialing\0",
	"Connecting\0", 
	"Ringing\0",
	"Ringtone\0",
	"Talking1\0",
	"Talking2\0",
	"Disconnect1\0",
	"Disconnect2\0",
	"Disconnect3\0",
	"Disconnect\0",
    "WaitReconnect\0",
	"Reconnect\0"
};


typedef enum
{
	RStr=0,
		OffHook,
		OnHook,
		HangFlash,
		Dial,
		Ack,
		TimeOut
} EventType;
struct CONNDATA
{
	char *connId;
	char *mode;
	struct CONNDATA* next;
};


static void usage(char*);
static char* progName = "CASim";
static int gatewayPort=2427, callAgentPort=2727;
static char *gatewayHost;
static char *callAgent=NULL;//not used
static char *reqOnHook = "HU", *reqOffHook = "HD";
static char  myHostName[100];
static long hexSource=160;
static long tIdSource=1000;
struct timeval pulseTime = {1,0};
char callId[32], connId[32];
mgcHash initVars, calls;
//mgcHash endpoints[10], phones[10], tidLog[2];
mgcHash endpoints[20], phones[20], tidLog[2];
int epCount=0;
//char *epPhoneNums[20];
char *epPhoneNums[32];

/* ??? This assumes that the RGW only manages a single endpoint.
 * Properly, this information should be stored in an endpoint object
 */
/* events we are reporting */
mgcSockAddr requestListener=NULL;

void handleNotify(mgcMsg, EndPointData*);
void handleRstrInPrgs(EndPointData*epd);
char* genNewHexString(void);
char* genNewTId(EndPointData*epd);
mgcAckType checkSigAndNotify(mgcMsg, EndPointData*);
void loadEpData(char*);
void loadInitVars(char*);
char* getInitVar(char*);
int  doInput(SOCKET), doMsg(mgcMsg), doAck(mgcAck), doPulse(void);
int procInput(char *command);
char* stateEnumToName(stateType);
void changState(EndPointData*,stateType);
void changCallState(CALLDATA*, stateType);
mgcMsgType getMsgType(char*);

/* this is a general function to send MGCP commands and save it in MSGQ */
int sendMgcpComm(mgcMsgType, EndPointData*, char*, char*, char*, char*,
			 char*, char*, char*, char*, char*, char*, char*);

CALLDATA* createCallData();
void destoryCallData(CALLDATA*);
CALLDATA* nextcall(EndPointData* epd, CALLDATA* call);
void deletecall(EndPointData* epd, CALLDATA* call);
int enterTimeOut( EndPointData*, long );
void doTimeOut( EndPointData*, int);
struct CONNDATA* createConnData();
void destoryConnData(struct CONNDATA*);
 
void processOnHook(EndPointData*, mgcMsg);
void processOffHook(EndPointData*, mgcMsg);
void processDial(EndPointData*, mgcMsg);
void processQNotify(EndPointData*);
void processNextMsg(EndPointData*, mgcMsg);
void processCallFlow(EndPointData*, EventType, mgcMsg);
void processBuzy(EndPointData*, mgcMsg);


#endif