/* 
 * Copyright (C) 1999-2000 Computer & Communications Research Laboratories,
 *				           Industrial Technology Research Institute
 */
/*
 * CASim.c
 */
/*////////String Handle/////////////////////////////////////////////
#include <windows.h>
#include <iostream.h>
#include "Shlwapi.h"
*////////////////////////////////////////////////////////////////////////////
#include "mgcp.h"
#include "trace.h"
#include "tools.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef WIN32
#include <winsock.h>
#include <time.h>
#endif

#ifdef SOLARIS
#include <unistd.h>
#endif

#include <ctype.h>
#include "CASim.h"

static void enterMSGQ(struct MSGQ* mqe, mgcMsg msg)
{
    struct MSGDATA* mqd = (struct MSGDATA*)malloc(sizeof(struct MSGDATA));

	if ( mqe==NULL ) {
		free(mqd);
		return;
	}

	mqd->m = strdup(mgcStrAsCStr(mgcMsgAsStr(msg)));
	mqd->tid = ATOI(mgcMsgGetTId(msg));
	mqd->ack = NULL;
    mqd->next = NULL;

    if( mqe->headQ==NULL ) 
		mqe->headQ = mqd;
    else 
		mqe->tailQ->next = mqd;

    mqe->tailQ = mqd;
    mqe->sizeQ++;
}

static struct MSGDATA* leaveMSGQ(struct MSGQ* mqe) 
{
    struct MSGDATA* mqd = NULL;

    if( mqe->headQ==NULL ) {
		fprintf(stderr, "\n[MSGQ] attempt to leave empty queue\n");
		/* ??? nothing appropriate to return */
		return NULL;
    }

    mqd = mqe->headQ;
    mqe->headQ = mqd->next;

    mqe->sizeQ--;
	return mqd;
}

mgcMsg setAckMSGQ(struct MSGQ* mqe, mgcAck ack)
{
	struct MSGDATA* mqd = NULL;
	struct MSGDATA* pre = NULL;
	int tid = ATOI(mgcAckGetTId(ack));
	pre = mqd = mqe->headQ;

	while ( mqd!=NULL ) {
		if ( mqd->tid==tid ) {
			mgcMsg msg = mgcMsgNew(getMsgType(mqd->m));
			mgcMsgParse(msg, mqd->m);

			pre->next = mqd->next;			
			mqe->sizeQ--;
			if ( mqe->headQ==pre )
				mqe->headQ = mqd->next;
			freeMSGDATA(mqd);
			return msg;  /* TID is found in this message queue, return message */
		}
		pre = mqd;
		mqd = mqd->next;
	}
	
	return 0;
}

void freeMSGDATA(struct MSGDATA* mqd)
{
	if (mqd) {
		free(mqd->m);
		if (mqd->ack) free(mqd->ack);
		free(mqd);
	}
}

mgcMsgType getMsgType(char* _this)
{
	if ( strncmp(_this,"EPCF",4) )
		return mgcEPtConfig;
	else if ( strncmp(_this,"CRCX",4) )
		return mgcCreatConn;		
	else if ( strncmp(_this,"MDCX",4) )
		return mgcModConn;		
	else if ( strncmp(_this,"DLCX",4) )
		return mgcDelConn;		
	else if ( strncmp(_this,"RQNT",4) )
		return mgcNotifReq;		
	else if ( strncmp(_this,"NTFY",4) )
		return mgcNotify;		
	else if ( strncmp(_this,"AUEP",4) )
		return mgcAuditEPt;		
	else if ( strncmp(_this,"AUCX",4) )
		return mgcAuditConn;
	else if ( strncmp(_this,"RSIP",4) )
		return mgcRstrInPrgs;
	else 
		return mgcUnknown;

}

void myDupCB(mgcMsg m, mgcAck s) 
{
    fprintf(stderr, "Dup ack %d set for %s\n", 
	    mgcAckGetType(s), mgcMsgGetTId(m));
}

int main(int argc, char**argv)
{

	char logfname[20];
	char *epfname;
	struct mgcExtEvents listenTo[2];
///////////////////for UI////////////////////
	int recv_flag;
	char recv_stepbystep[3];
/////////////////////////////////////////////
	sprintf(logfname, "calog_%s.txt", gettime());

	TRACE_BEGIN(logfname)

#ifdef WIN32
	initSockLib();
#endif

	if (argc != 2) {
		usage("usage error: specify initfile.\n");
		exit(1);
	}
		
	loadInitVars(argv[1]);

	/*use tidLog to log tid*/
	tidLog[0] = mgcHashNew(10, 1, MGCHASH_POINTER);
	calls = mgcHashNew(10, 0 , MGCHASH_POINTER);

    traceLevel = ATOI(getInitVar("trace"));
	logFlag = ATOI(getInitVar("log"));

    callAgentPort = ATOI(getInitVar("caPort"));
    if( callAgentPort <= 0 ) {
		usage("error in caPort");
    }
    gethostname(myHostName,99);

	//////////////////////////////////////////////////for UI //////////////
	UIIP = getInitVar("UIIP");
	UIport = atoi(getInitVar("UIport"));
	printf("\nUIIP=%s\n",UIIP);
	printf("\nUIport=%d\n",UIport);
	OpenClientSocket(UIIP,UIport);	
	////////////////////////////////////////////////////////////
	/////qUIܬO_nstep by step
	////////////////////////////////////////////////////////////
	if(isUIon==TRUE){
		strcpy(recv_stepbystep,"   ");
		recv_flag = recv(conn_socket,recv_stepbystep,3,0);
		if(strcmp(recv_stepbystep,"yes")==0){
			StepByStep = 1;
			printf("\nStep by Step Mode");
		}else{
			StepByStep = 0;
			printf("Normal Mode\n");
		}
	}	
	/////////////////////////////////////////////////////////////
	/* load endpoint data*/
	epfname = getInitVar("endpointfile");
	loadEpData(epfname);

    mgcInit();			/* >>> mgcLoop */
    {
		int delay = ATOI(getInitVar("delay"));
		if( delay<50000 ) delay=50000;
		mgcLoopSetDelay( delay );
    }

    listenTo[0].fd = 0;
	listenTo[0].cb = NULL;

    mgcDupMsgCB = myDupCB;
    mgcLoop(callAgentPort, doMsg, doAck, listenTo, &pulseTime, doPulse);

    printf("\nexiting\n");

#ifdef WIN32
    cleanSock();
#endif

	TRACE_END

    return 0;
}


int doMsg(mgcMsg msg) 
{
    mgcAck ack = NULL;
    mgcAckType ackType;
    EndPointData *epd;
	int isNotify=0, isRSIP=0;
	EventType event = -1;
	
	TRACE(1)
    sprintf(logbuf, "MSG received ==> %s %s %s\n", 
			mgcMsgVerb[mgcMsgGetType(msg)],
			mgcMsgGetEPt(msg),
			mgcMsgGetTId(msg));
	PRINT(logbuf);
    endTRACE(1)

    TRACE(2)
	sprintf(logbuf,"{%s}\n", mgcStrAsCStr(mgcMsgAsStr(msg)));
	PRINT(logbuf);
    endTRACE(2)

    /* ??? Resolved (check first, handle as part of each handler)
     * should we handle piggybacked notification requests
     * what happens if the command fails (nack)
     * (I think that it should not have an effect, 
     * this means that reportSignals, storeNotify needs to be called 
     * in each handler)
     */

    epd = mgcHashItem(endpoints[0], mgcMsgGetEPt(msg));
    if( epd==NULL ) {
		TRACE(1)
		sprintf( logbuf,"\nMSG received for unknown endpoint [%s]\n",
			mgcMsgGetEPt(msg));
		PRINT(logbuf);
		endTRACE(1)
		return 0;
    }
    ack = mgcAckNew(mgcAckOK);
    mgcAckSetTId(ack, mgcMsgGetTId(msg));

    ackType = checkSigAndNotify(msg, epd);

    if( ackType==mgcAckOK 
		|| ackType==mgcAckOnHook 
		|| ackType==mgcAckOffHook) {

		switch( mgcMsgGetType(msg) ) {
		case mgcEPtConfig: 
			ackType = mgcAckProtoErr; 
			break;

		case mgcCreatConn: 
			ackType = mgcAckProtoErr; 
			break;

		case mgcDelConn: 
			epd->isOnHook = 1;
			ackType = checkSigAndNotify(msg, epd);
			break;

		case mgcModConn:  
			ackType = mgcAckProtoErr; 
			break;

		case mgcNotifReq: 
			ackType = mgcAckProtoErr; 
			break;

		case mgcNotify:
			ackType = checkSigAndNotify(msg, epd);
			if ( ackType=mgcAckOK )
				isNotify = 1;
			break;

		case mgcAuditEPt: 
			ackType = mgcAckProtoErr; 
			break;

		case mgcAuditConn: 
			ackType = mgcAckProtoErr; 
			break;

		case mgcRstrInPrgs: 
			isRSIP = 1;
			ackType = mgcAckGetType(ack);
			break;
						
		default:
			sprintf(logbuf,"Message not recognized\n%s\n\n",
				mgcStrAsCStr(mgcMsgAsStr(msg)));
			PRINT(logbuf);
			ackType = mgcAckProtoErr;
		}
    }

    mgcAckSetType(ack, ackType);
   
    TRACE(2)
	mgcStr s = mgcAckAsStr(ack);
	sprintf( logbuf,"\nSend ACK ==> {%s}\n", mgcStrAsCStr(s));
	PRINT(logbuf);
    endTRACE(2)

	mgcAckSend(ack, mgcMsgGetAddr(msg));

	/* if ep is in Init state, discard message */
	if ( epd->epState!=Init && isNotify ) {//handleNotify(msg, epd); 
		mgcParmStr O = mgcMsgGetParm(msg, "O");
	
		/* if this call have messages in its message queue, it means these messages
		   are not acked yet. We should queue this notify to be proccessed later */
		if ( epd->msgQ->sizeQ!=0 ) {
			printf("\nenter notify queue!!!!!!!\n");
			enterMSGQ( epd->notifyQ, msg);
			return 0;
		}

		if (contains(O,"HU")||contains(O,"hu"))
			event = OnHook;
		else if (contains(O,"HD")||contains(O,"hd"))
			event = OffHook;
		else if (contains(O,"BZ")||contains(O,"bz"))
		{}
		else if (contains(O,"HF")||contains(O,"hf"))
			event = HangFlash;
		else 
			event = Dial;
	}
	if ( isRSIP ) {
		event = RStr; 
		//handleRstrInPrgs(msg, epd, ack);
	}
	if (event >= 0) {
		processCallFlow(epd, event, msg);
	}
    mgcMsgFree(msg);			/* responsible (could pass on) */
    return 0;
}


int doAck(mgcAck ack) 
{
	EndPointData *epd,*ep2; 
	CALLDATA* call = NULL;
	mgcParmStr I = NULL;
	char* sdp;
	char* tid;
	int type;
	mgcMsg oldmsg;	

	TRACE(1)
    sprintf( logbuf,"\nACK received ==> {%s}\n", mgcStrAsCStr(mgcAckAsStr(ack)));
	PRINT(logbuf);
    endTRACE(1)

	type = mgcAckGetType(ack);
	tid = mgcAckGetTId(ack);
	epd = mgcHashItem(tidLog[0], tid); /* epd is current endpoint that this ACK for*/

	oldmsg = setAckMSGQ( epd->msgQ, ack);

	if ( type==200 && epd!=NULL )	/* if ack is error, do nothing*/ 
	{
		if ( epd->epState==Init ) { /* Only happen when initializing */
			// init all ep data
			changState( epd, Idle);
		}
		else {
			
			I = mgcAckGetParm(ack, "I");
			sdp = mgcAckGetSDP(ack);
	
			if (I) {
				epd->conn = createConnData();
				epd->conn->connId = strdup(I);
			}
			if (sdp) 
				epd->sdp = strdup(sdp);

			if ( epd->latestTId==ATOI(tid) ) {
				processCallFlow(epd, Ack, oldmsg);  //oldmsg has no meaning
				call = epd->call;
				// when Disconnect1 we must not proccessQNotify,
				// because we should ensure that ep2's DLCX is sent
				// this QNotify will still process on next callflow state
				if ( epd->notifyQ->headQ!=NULL && 
					//epd->proccessQ==0 && 
					call &&
					call->callflowState!=Disconnect1 &&
					call->callflowState!=Disconnect2 ) {
					//if ( call->callflowState==Disconnect1 )
					//	processNextMsg(epd);
					processQNotify(epd);
				}
				else
				{}
					//processNextMsg(epd,oldmsg);	honda's first mark			
			}
			else {
				changState( epd, Idle);
				epd->conn = NULL;
				epd->call = NULL;

				epd->epTalkingto = NULL;
				epd->isOnHook = 1;
				epd->isBuzy = 0;
				epd->sdp = NULL;
			}
		}
	}
	else // when ack is error, set endpoint to Idle
	{
		changState( epd, Idle);
		epd->conn = NULL;
		epd->call = NULL;
		epd->epTalkingto = NULL;
		epd->isOnHook = 1;
		epd->isBuzy = 0;
		epd->sdp = NULL;

		ep2 = ((epd->epTalkingto)?mgcHashItem(endpoints[0],epd->epTalkingto):NULL);
		if (ep2) {
			changState( ep2, Idle);
			ep2->conn = NULL;
			ep2->call = NULL;
			ep2->epTalkingto = NULL;
			ep2->isOnHook = 1;
			ep2->isBuzy = 0;
			ep2->sdp = NULL;
		}
	}
//    mgcMsgDelonAck(ack,mgcMsgGetAddr(oldmsg));			/* responsible (could pass on) */
    return 0;
}

void processQNotify(EndPointData* epd)
{
	struct MSGDATA* ntfyd = leaveMSGQ(epd->notifyQ);
//	struct MSGDATA* msgd;
	mgcMsg _this = mgcMsgNew(mgcNotify);

/*	msgd = leaveMSGQ(epd->msgQ);
	freeMSGDATA(msgd);
*/
	printf("\nprocess queued notify!...notifyQ size=%d\n",epd->notifyQ->sizeQ);
	mgcMsgParse( _this, ntfyd->m);

	epd->proccessQ++;
	handleNotify( _this, epd);
	epd->proccessQ--;
}

void processCallFlow(EndPointData* epd, EventType event, mgcMsg msg)
{
	EndPointData* ep2;
	CALLDATA* call = epd->call;
	ep2 = ((epd->epTalkingto)?mgcHashItem(endpoints[0],epd->epTalkingto):NULL);

	if (!epd->call && event != RStr && event != OffHook)
		return;

	if (event == RStr) {
		// reInitialize endpoint data
		changState(epd,Init);
		handleRstrInPrgs(epd);
		return;
	}

	if (epd->epState==Idle && event == OffHook) {
		//if ( epd->epState==Idle ) {
		epd->isOnHook = 0;
		epd->call = createCallData();  //callflowstate set to Idle
		epd->call->caller = epd->gwEndPointId;
		epd->callhead = epd->call;

		sendMgcpComm(mgcNotifReq,						/* mgcp command type	  */
					 epd,								/* endpoint ID			  */
					 NULL,								/* CallId				  */
					 NULL,								/* ConnectionId			  */
					 genNewHexString(),					/* RequestIdentifier	  */
					 NULL,								/* LocalConnectionOptions */
					 NULL,								/* Connection Mode		  */
					 "HU(N),[0-9T](D)",					/* RequestedEvents		  */
					 "DL",								/* SignalRequests		  */
					 "(XXXXX)",							/* digitMap				  */
                     NULL,								/* ObservedEvents		  */
					 NULL,								/* RemoteConn Descriptor  */
					 NULL);								/* LocalConn Descriptor   */
		return;
	}

	switch (epd->call->callflowState) 
	{
	case Idle:
		switch (event)
		{
		case OnHook:
			epd->isOnHook = 1;
			sendMgcpComm(mgcNotifReq,				/* mgcp command type	  */
					 epd,							/* endpoint ID			  */
					 NULL,							/* CallId				  */
					 NULL,							/* ConnectionId			  */
					 genNewHexString(),				/* RequestIdentifier	  */
					 NULL,							/* LocalConnectionOptions */
					 NULL,							/* Connection Mode		  */
					 "HD(N)",						/* RequestedEvents		  */
					 NULL,							/* SignalRequests		  */
					 NULL,							/* digitMap				  */
					 NULL,							/* ObservedEvents		  */
					 NULL,							/* RemoteConn Descriptor  */
					 NULL );						/* LocalConn Descriptor   */
			break;
		case OffHook:
			epd->isOnHook = 0;
			break;
		case HangFlash:
			break;
		case Dial:
			break;
		case Ack:
			if ( epd->isOnHook!=1 ) {
				changCallState( epd->call, Dialing);
				changState( epd, Dialing);
				//printf("\nstart testing");
				//epd->call->timeoutid = enterTimeOut(epd, 5000000);
			}
			else {
				changCallState( epd->call, Idle);
				changState( epd, Idle);
				epd->epTalkingto = NULL;
				epd->isOnHook = 1;
				epd->isBuzy = 0;
				epd->sdp = NULL;
	
			}
			break;
		case TimeOut:
			break;
		default:
			break;
		}
		break;
	case Dialing:
		switch (event)
		{
		case OnHook:
			epd->isOnHook = 1;
			sendMgcpComm(mgcNotifReq,				/* mgcp command type	  */
					 epd,							/* endpoint ID			  */
					 NULL,							/* CallId				  */
					 NULL,							/* ConnectionId			  */
					 genNewHexString(),				/* RequestIdentifier	  */
					 NULL,							/* LocalConnectionOptions */
					 NULL,							/* Connection Mode		  */
					 "HD(N)",						/* RequestedEvents		  */
					 NULL,							/* SignalRequests		  */
					 NULL,							/* digitMap				  */
					 NULL,							/* ObservedEvents		  */
					 NULL,							/* RemoteConn Descriptor  */
					 NULL );						/* LocalConn Descriptor   */
			break;
		case OffHook:
			epd->isOnHook = 0;
			break;
		case HangFlash:
			break;
		case Dial:
			processDial( epd, msg);
			break;
		case Ack:
			if ( epd->isOnHook!=1 ) {
				changCallState( epd->call, Connecting);
				changState( epd, Connecting);
				//ep2->call = call;
				//ep2->call->callee = ep2->gwEndPointId;
				if (ep2->callhead) {	//ep2 should not have any call, and callhead should be NULL cause ep2 is OnHook...
					ep2->call->calleenext = call;
					//ep2->call = call;
				}
				else {
					ep2->callhead = ep2->call = call;
					ep2->call->callee = ep2->gwEndPointId;
					ep2->epTalkingto = strdup(epd->gwEndPointId);				
				}

				sendMgcpComm(mgcCreatConn,				/* mgcp command type	  */
						 ep2,						/* endpoint ID			  */
						 call->callId,				/* CallId				  */
						 NULL,						/* ConnectionId			  */
						 genNewHexString(),			/* RequestIdentifier	  */
						 epd->localConnOpt,			/* LocalConnectionOptions */
						 "SENDRECV",				/* Connection Mode		  */
						 NULL,						/* RequestedEvents		  */
						 "RG",						/* SignalRequests		  */
						 NULL,						/* digitMap				  */
						 NULL,						/* ObservedEvents		  */
						 epd->sdp,					/* RemoteConn Descriptor  */
						 NULL);						/* LocalConn Descriptor   */
			}
			else {
				changCallState( epd->call, Idle);
				changState( epd, Idle);
				if (epd->conn) destoryConnData(epd->conn);
				epd->conn = NULL;
				deletecall(epd, epd->call);
				if ( call && ep2 && ep2->epState==Idle ) destoryCallData(call);

				epd->epTalkingto = NULL;
				epd->isOnHook = 1;
				epd->isBuzy = 0;
				epd->sdp = NULL;
			}
			break;
		case TimeOut:
			//printf("\nepd->timeoutid=%d\nepd->call->timeoutid=%d",epd->timeoutid, epd->call->timeoutid);
			break;
		default:
			break;
		}
		break;
	case Connecting:
		switch (event)
		{
		case OnHook:
			epd->isOnHook = 1;
			sendMgcpComm(mgcDelConn,					/* mgcp command type	  */
						 epd,							/* endpoint ID			  */
						 call->callId,					/* CallId				  */
						 epd->conn->connId,				/* ConnectionId			  */
						 genNewHexString(),				/* RequestIdentifier	  */
						 NULL,							/* LocalConnectionOptions */
						 NULL,							/* Connection Mode		  */
						 "HD(N)",						/* RequestedEvents		  */
						 NULL,							/* SignalRequests		  */
						 NULL,							/* digitMap				  */
						 NULL,							/* ObservedEvents		  */
						 NULL,							/* RemoteConn Descriptor  */
						 NULL );						/* LocalConn Descriptor   */
			break;
		case OffHook:
			epd->isOnHook = 0;
			break;
		case HangFlash:
			break;
		case Dial:
			break;
		case Ack:
			if ( epd->isOnHook!=1 ) {
				changCallState( epd->call, Disconnect1);
				changState( epd, Idle);
			}
			else {
				if ( epd->epState==Connecting ) {
					changCallState( epd->call, Disconnect2);
					changState( epd, Idle);

					sendMgcpComm(mgcDelConn,				/* mgcp command type	  */
								 ep2,						/* endpoint ID			  */
								 call->callId,				/* CallId				  */
								 ep2->conn->connId,			/* ConnectionId			  */
								 genNewHexString(),			/* RequestIdentifier	  */
								 NULL,						/* LocalConnectionOptions */
								 NULL,						/* Connection Mode		  */
								 NULL,						/* RequestedEvents		  */
								 "E",						/* SignalRequests		  */  //Sharon 2001/04/25 change s:"E"
								 NULL,						/* digitMap				  */
								 NULL,						/* ObservedEvents		  */
								 NULL,						/* RemoteConn Descriptor  */
								 NULL);						/* LocalConn Descriptor   */

					epd->epTalkingto = NULL;
					epd->isOnHook = 1;
					epd->isBuzy = 0;
					epd->sdp = NULL;
				} 
				else if ( epd->epState==Idle ) {	
					changCallState( epd->call, Ringing);
					changState( epd, Ringing);
					sendMgcpComm(mgcModConn,				/* mgcp command type	  */
						 ep2,						/* endpoint ID			  */
						 call->callId,				/* CallId				  */
						 ep2->conn->connId,			/* ConnectionId			  */
						 genNewHexString(),			/* RequestIdentifier	  */
						 epd->localConnOpt,			/* LocalConnectionOptions */
						 NULL,						/* Connection Mode		  */
						 NULL,						/* RequestedEvents		  */
						 "RT",						/* SignalRequests		  */
						 NULL,						/* digitMap				  */
						 NULL,						/* ObservedEvents		  */
						 epd->sdp,					/* RemoteConn Descriptor  */
						 NULL);						/* LocalConn Descriptor   */
				}
			}
			break;
		case TimeOut:
			break;
		default:
			break;
		}
		break;
	case Ringing:
		switch (event)
		{
		case OnHook:
			epd->isOnHook = 1;
			sendMgcpComm(mgcDelConn,					/* mgcp command type	  */
						 epd,							/* endpoint ID			  */
						 call->callId,					/* CallId				  */
						 epd->conn->connId,				/* ConnectionId			  */
						 genNewHexString(),				/* RequestIdentifier	  */
						 NULL,							/* LocalConnectionOptions */
						 NULL,							/* Connection Mode		  */
						 "HD(N)",						/* RequestedEvents		  */
						 NULL,							/* SignalRequests		  */
						 NULL,							/* digitMap				  */
						 NULL,							/* ObservedEvents		  */
						 NULL,							/* RemoteConn Descriptor  */
						 NULL );						/* LocalConn Descriptor   */
			break;
		case OffHook:
			epd->isOnHook = 0;
			enterMSGQ(epd->msgQ, msg);
			break;
		case HangFlash:
			break;
		case Dial:
			break;
		case Ack:
			if ( epd->isBuzy==1 ) {
				changCallState( epd->call, Disconnect1);
				changState( epd, Idle);
				epd->isBuzy = 0;
			}
			else if ( epd->isOnHook!=1 ) {
				changCallState( epd->call, Ringtone);
				changState( epd, Ringtone);
			}
			else {
				changCallState( epd->call, Disconnect2);
				changState( epd, Idle);
				destoryConnData(epd->conn);
				epd->conn = NULL;
				epd->call = NULL;
				if ( epd->notifyQ->headQ!=NULL ) 
					processQNotify(epd);
				sendMgcpComm(mgcDelConn,				/* mgcp command type	  */
						 ep2,						/* endpoint ID			  */
						 call->callId,				/* CallId				  */
						 ep2->conn->connId,			/* ConnectionId			  */
						 genNewHexString(),			/* RequestIdentifier	  */
						 NULL,						/* LocalConnectionOptions */
						 NULL,						/* Connection Mode		  */
						 "hd",						/* RequestedEvents		  */
						 "E",						/* SignalRequests		  */
						 NULL,						/* digitMap				  */
						 NULL,						/* ObservedEvents		  */
						 NULL,						/* RemoteConn Descriptor  */
						 NULL);						/* LocalConn Descriptor   */
			}
			break;
		case TimeOut:
			break;
		default:
			break;
		}
		break;
	case Ringtone:
		switch (event)
		{
		case OnHook:
			epd->isOnHook = 1;
			sendMgcpComm(mgcDelConn,					/* mgcp command type	  */
						 epd,							/* endpoint ID			  */
						 call->callId,					/* CallId				  */
						 epd->conn->connId,				/* ConnectionId			  */
						 genNewHexString(),				/* RequestIdentifier	  */
						 NULL,							/* LocalConnectionOptions */
						 NULL,							/* Connection Mode		  */
						 "HD(N)",						/* RequestedEvents		  */
						 NULL,							/* SignalRequests		  */
						 NULL,							/* digitMap				  */
						 NULL,							/* ObservedEvents		  */
						 NULL,							/* RemoteConn Descriptor  */
						 NULL );						/* LocalConn Descriptor   */
			break;
		case OffHook:
			epd->isOnHook = 0;
			if ( epd->msgQ->headQ==NULL ) 
				sendMgcpComm(mgcModConn,				/* mgcp command type	  */
							 epd,						/* endpoint ID			  */
							 call->callId,				/* CallId				  */
							 epd->conn->connId,			/* ConnectionId			  */
							 genNewHexString(),			/* RequestIdentifier	  */
							 NULL,						/* LocalConnectionOptions */
							 NULL,						/* Connection Mode		  */
							 "HU(N)",					/* RequestedEvents		  */
							 " ",						/* SignalRequests		  */
							 NULL,						/* digitMap				  */
							 NULL,						/* ObservedEvents		  */
							 NULL,						/* RemoteConn Descriptor  */
							 NULL);						/* LocalConn Descriptor   */
		else 
				enterMSGQ( epd->notifyQ, msg); 
			break;
		case HangFlash:
			break;
		case Dial:
			break;
		case Ack:
			if ( epd->isBuzy==1 ) {
				changCallState( epd->call, Disconnect1);
				changState( epd, Idle);
				epd->isBuzy = 0;
			}
			else if ( epd->isOnHook!=1 ) {
				changCallState( epd->call, Talking2);
				changState( epd, Talking2);
				sendMgcpComm(mgcModConn,				/* mgcp command type	  */
						 ep2,						/* endpoint ID			  */
						 call->callId,				/* CallId				  */
						 ep2->conn->connId,			/* ConnectionId			  */
						 genNewHexString(),			/* RequestIdentifier	  */
						 epd->localConnOpt,			/* LocalConnectionOptions */
						 "SENDRECV",				/* Connection Mode		  */
						 NULL,						/* RequestedEvents		  */
						 " ",						/* SignalRequests		  */
						 NULL,						/* digitMap				  */
						 NULL,						/* ObservedEvents		  */
						 NULL,						/* RemoteConn Descriptor  */
						 NULL);						/* LocalConn Descriptor   */
			}
			else {
				changCallState( epd->call, Disconnect2);
				changState( epd, Idle);
				destoryConnData(epd->conn);
				epd->conn = NULL;
				epd->call = NULL;

				if ( epd->notifyQ->headQ!=NULL ) 
					processQNotify(epd);

				sendMgcpComm(mgcDelConn,				/* mgcp command type	  */
						 ep2,						/* endpoint ID			  */
						 call->callId,				/* CallId				  */
						 ep2->conn->connId,			/* ConnectionId			  */
						 genNewHexString(),			/* RequestIdentifier	  */
						 NULL,						/* LocalConnectionOptions */
						 NULL,						/* Connection Mode		  */
						 "hd",						/* RequestedEvents		  */
						 "E",						/* SignalRequests		  */
						 NULL,						/* digitMap				  */
						 NULL,						/* ObservedEvents		  */
						 NULL,						/* RemoteConn Descriptor  */
						 NULL);						/* LocalConn Descriptor   */
			}
			break;
		case TimeOut:
			break;
		default:
			break;
		}
		break;
	case Talking1:
		switch (event)
		{
		case OnHook:
			epd->isOnHook = 1;
		///////////////////////////////////////////////////////////////////////////////////////////////////
		     if   (  strcmp(epd->gwEndPointId, epd->call->caller)  ) // callee hang up first  /// (OcallercompareXӵGO0, ҥHOcallee~|if )
			 {		  
				      
				       changCallState( epd->call, WaitReconnect);
			            changState(epd,WaitReconnect);
						sendMgcpComm(mgcNotifReq,					/* mgcp command type	  */
															 epd,							/* endpoint ID			  */
															 NULL,							/* CallId				  */
															 NULL,							/* ConnectionId			  */
															 genNewHexString(),				/* RequestIdentifier	  */
															 NULL,							/* LocalConnectionOptions */
															 NULL,							/* Connection Mode		  */
															 "HD(N)",						/* RequestedEvents		  */
															 NULL,							/* SignalRequests		  */
															 NULL,							/* digitMap				  */
															 NULL,							/* ObservedEvents		  */
															 NULL,							/* RemoteConn Descriptor  */
															 NULL );						/* LocalConn Descriptor   */
		
						/************/
					//	sendMgcpComm(mgcNotifReq,					/* mgcp command type	  */
					//										 ep2,							/* endpoint ID			  */
					//										 NULL,							/* CallId				  */
					//										 NULL,							/* ConnectionId			  */
					//										 genNewHexString(),				/* RequestIdentifier	  */
					//										 NULL,							/* LocalConnectionOptions */
					//										 NULL,							/* Connection Mode		  */
					//										 "HU(N)",						/* RequestedEvents		  */
					//										 "E",							/* SignalRequests		  */
					//										 NULL,							/* digitMap				  */
					//										 NULL,							/* ObservedEvents		  */
					//										 NULL,							/* RemoteConn Descriptor  */
					//										 NULL );						/* LocalConn Descriptor   */
		
						/************/
						 printf("\n**Enter Time Out !  : %s \n",epd->gwEndPointId	);
				       enterTimeOut(epd, 5000000);
			 }else{

		///////////////////////////////////////////////////////////////////////////////////////////////////	
			sendMgcpComm(mgcDelConn,					/* mgcp command type	  */
						 epd,							/* endpoint ID			  */
						 call->callId,					/* CallId				  */
						 epd->conn->connId,				/* ConnectionId			  */
						 genNewHexString(),				/* RequestIdentifier	  */
						 NULL,							/* LocalConnectionOptions */
						 NULL,							/* Connection Mode		  */
						 "HD(N)",						/* RequestedEvents		  */
						 NULL,							/* SignalRequests		  */
						 NULL,							/* digitMap				  */
						 NULL,							/* ObservedEvents		  */
						 NULL,							/* RemoteConn Descriptor  */
						 NULL );						/* LocalConn Descriptor   */
			//////////////
			 }
			 /////////////
			break;
		case OffHook:
			epd->isOnHook = 0;
			break;
		case HangFlash:
			break;
		case Dial:
			break;
		case Ack:			
			if ( epd->isOnHook!=1 ) {
				/****
				some cases we discared, ex. 3-way calling..
				****/
			}
			else {
				changCallState( epd->call, Disconnect1);
				changState( epd, Idle);
				destoryConnData(epd->conn);
				epd->conn = NULL;
				deletecall(epd, call);

				if ( epd->notifyQ->headQ!=NULL ) 
					processQNotify(epd);
				if ( !ep2->conn )
					return;

				sendMgcpComm(mgcDelConn,				/* mgcp command type	  */
						 ep2,						/* endpoint ID			  */
						 call->callId,				/* CallId				  */
						 ep2->conn->connId,			/* ConnectionId			  */
						 genNewHexString(),			/* RequestIdentifier	  */
						 NULL,						/* LocalConnectionOptions */
						 NULL,						/* Connection Mode		  */
						 NULL,						/* RequestedEvents		  */
						 "E",						/* SignalRequests		  */
						 NULL,						/* digitMap				  */
						 NULL,						/* ObservedEvents		  */
						 NULL,						/* RemoteConn Descriptor  */
						 NULL);						/* LocalConn Descriptor   */
			}
			break;
		case TimeOut:
			break;
		default:
			break;
		}
		break;
	case Talking2:
		switch (event)
		{
		case OnHook:
			epd->isOnHook = 1;
			sendMgcpComm(mgcDelConn,					/* mgcp command type	  */
						 epd,							/* endpoint ID			  */
						 call->callId,					/* CallId				  */
						 epd->conn->connId,				/* ConnectionId			  */
						 genNewHexString(),				/* RequestIdentifier	  */
						 NULL,							/* LocalConnectionOptions */
						 NULL,							/* Connection Mode		  */
						 "HD(N)",						/* RequestedEvents		  */
						 NULL,							/* SignalRequests		  */
						 NULL,							/* digitMap				  */
						 NULL,							/* ObservedEvents		  */
						 NULL,							/* RemoteConn Descriptor  */
						 NULL );						/* LocalConn Descriptor   */
			break;
		case OffHook:
			epd->isOnHook = 0;
			break;
		case HangFlash:
			break;
		case Dial:
			break;
		case Ack:
			if ( epd->isOnHook!=1 ) {
				changCallState( epd->call, Talking1);
				changState( epd, Talking1);
			}
			else {
				changCallState( epd->call, Disconnect1);
				changState( epd, Idle);
				destoryConnData(epd->conn);
				epd->conn = NULL;
				epd->call = NULL;

				if ( epd->notifyQ->headQ!=NULL ) 
					processQNotify(epd);
				if ( !ep2->conn )
					return;

				sendMgcpComm(mgcDelConn,				/* mgcp command type	  */
						 ep2,						/* endpoint ID			  */
						 call->callId,				/* CallId				  */
						 ep2->conn->connId,			/* ConnectionId			  */
						 genNewHexString(),			/* RequestIdentifier	  */
						 NULL,						/* LocalConnectionOptions */
						 NULL,						/* Connection Mode		  */
						 NULL,						/* RequestedEvents		  */
						 "E",						/* SignalRequests		  */
						 NULL,						/* digitMap				  */
						 NULL,						/* ObservedEvents		  */
						 NULL,						/* RemoteConn Descriptor  */
						 NULL);						/* LocalConn Descriptor   */
			}
			break;
		case TimeOut:
			break;
		default:
			break;
		}
		break;
	case Disconnect1:
		switch (event)
		{
		case OnHook:
			epd->isOnHook = 1;
			break;
		case OffHook:
			epd->isOnHook = 0;
			break;
		case HangFlash:
			break;
		case Dial:
			break;
		case Ack:		
			if ( epd->isOnHook!=1 ) {
				changCallState( epd->call, Disconnect);
				changState( epd, Disconnect);
			}
			else {
				/* Disconnect1 strange case */
				changCallState( epd->call, Disconnect);
				changState( epd, Disconnect);
				deletecall(epd, epd->call); 
				sendMgcpComm(mgcNotifReq,			/* mgcp command type	  */
						 epd,						/* endpoint ID			  */
						 NULL,						/* CallId				  */
						 NULL,						/* ConnectionId			  */
						 genNewHexString(),			/* RequestIdentifier	  */
						 NULL,						/* LocalConnectionOptions */
						 NULL,						/* Connection Mode		  */
						 "HD(N)",					/* RequestedEvents		  */
						 NULL,						/* SignalRequests		  */
						 NULL,						/* digitMap				  */
						 NULL,						/* ObservedEvents		  */
						 NULL,						/* RemoteConn Descriptor  */
						 NULL);						/* LocalConn Descriptor   */
			}
			break;
		case TimeOut:
			break;
		default:
			break;
		}
		break;
	case Disconnect2:
		switch (event)
		{
		case OnHook:
			epd->isOnHook = 1;
			break;
		case OffHook:
			epd->isOnHook = 0;
			break;
		case HangFlash:
			break;
		case Dial:
			break;
		case Ack:
			if ( epd->isOnHook!=1 ) {
				/****
				Strange case, maybe error...
				****/
			    TRACE(1)
				sprintf( logbuf,"\n!!!Disconnect2 Strang case!!!\n\n");
				PRINT(logbuf);
			    endTRACE(1)
			}
			else {
				changCallState( epd->call, Idle);
				changState( epd, Idle);
				if (epd->conn) destoryConnData(epd->conn);
				epd->conn = NULL;
				deletecall(epd, epd->call);
				if ( call && ep2 && ep2->epState==Idle ) destoryCallData(call);
				epd->call = NULL;
				epd->epTalkingto = NULL;
				epd->isOnHook = 1;
				epd->isBuzy = 0;
				epd->sdp = NULL;
			}
			break;
		case TimeOut:
			break;
		default:
			break;
		}
		break;

	case Disconnect3:
		switch(event)
		{
		case Ack:
			printf("\nAck_DLCX\n");
			changCallState( epd->call, Disconnect1);
				changState( epd, Idle);
				destoryConnData(epd->conn);
				epd->conn = NULL;
				deletecall(epd, call);
				if ( epd->notifyQ->headQ!=NULL ) 
					processQNotify(epd);
				if ( !ep2->conn )
					return;
				sendMgcpComm(mgcDelConn,				/* mgcp command type	  */
						 ep2,						/* endpoint ID			  */
						 call->callId,				/* CallId				  */
						 ep2->conn->connId,			/* ConnectionId			  */
						 genNewHexString(),			/* RequestIdentifier	  */
						 NULL,						/* LocalConnectionOptions */
						 NULL,						/* Connection Mode		  */
						 NULL,						/* RequestedEvents		  */
						 "E",						/* SignalRequests		  */
						 NULL,						/* digitMap				  */
						 NULL,						/* ObservedEvents		  */
						 NULL,						/* RemoteConn Descriptor  */
						 NULL);						/* LocalConn Descriptor   */		
			break;
		default:
			 break;
		}
		break;

	case Disconnect:
		switch (event)
		{
		case OnHook:
			epd->isOnHook = 1;
			sendMgcpComm(mgcNotifReq,					/* mgcp command type	  */
						 epd,							/* endpoint ID			  */
						 NULL,							/* CallId				  */
						 NULL,							/* ConnectionId			  */
						 genNewHexString(),				/* RequestIdentifier	  */
						 NULL,							/* LocalConnectionOptions */
						 NULL,							/* Connection Mode		  */
						 "HD(N)",						/* RequestedEvents		  */
						 NULL,							/* SignalRequests		  */
						 NULL,							/* digitMap				  */
						 NULL,							/* ObservedEvents		  */
						 NULL,							/* RemoteConn Descriptor  */
						 NULL );						/* LocalConn Descriptor   */
			break;
		case OffHook:
			epd->isOnHook = 0;
			break;
		case HangFlash:
			break;
		case Dial:
			break;
		case Ack:
			if ( epd->isOnHook!=1 ) {
				changCallState( epd->call, Idle);
				changState( epd, Idle);
			}
			else {
				changCallState( epd->call, Idle);
				changState( epd, Idle);
				if (epd->conn) destoryConnData(epd->conn);
				epd->conn = NULL;
				if(ep2) deletecall(ep2, ep2->call);//add bySharon
				deletecall(epd, epd->call);
				if ( call && ep2 && ep2->epState==Idle ) destoryCallData(call);

				epd->epTalkingto = NULL;
				epd->isOnHook = 1;
				epd->isBuzy = 0;
				epd->sdp = NULL;
			}
			break;
		case TimeOut:
			break;
		default:
			break;
		}
	        break;
			//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case WaitReconnect:	
		switch (event){
	     case OnHook:
			changCallState( epd->call, Disconnect2);
			changState( epd, Disconnect2);
			changState( ep2, Idle);	//Sharon
			epd->isOnHook = 1;
			sendMgcpComm(mgcDelConn,					/* mgcp command type	  */
						 epd,							/* endpoint ID			  */
						 call->callId,					/* CallId				  */
						 epd->conn->connId,				/* ConnectionId			  */
						 genNewHexString(),				/* RequestIdentifier	  */
						 NULL,							/* LocalConnectionOptions */
						 NULL,							/* Connection Mode		  */
						 "HD(N)",						/* RequestedEvents		  */
						 NULL,							/* SignalRequests		  */
						 NULL,							/* digitMap				  */
						 NULL,							/* ObservedEvents		  */
						 NULL,							/* RemoteConn Descriptor  */
						 NULL );						/* LocalConn Descriptor   */
            sendMgcpComm(mgcDelConn,					/* mgcp command type	  */
						 ep2,							/* endpoint ID			  */
						 call->callId,					/* CallId				  */
						 ep2->conn->connId,				/* ConnectionId			  */
						 genNewHexString(),				/* RequestIdentifier	  */
						 NULL,							/* LocalConnectionOptions */
						 NULL,							/* Connection Mode		  */
						 "HD(N)",						/* RequestedEvents		  */
						 NULL,							/* SignalRequests		  */
						 NULL,							/* digitMap				  */
						 NULL,							/* ObservedEvents		  */
						 NULL,							/* RemoteConn Descriptor  */
						 NULL );						/* LocalConn Descriptor   */
			break;
		 case OffHook:
			 epd->isOnHook = 0;
			 changCallState( epd->call, Reconnect);
			changState( epd, Reconnect);							
            sendMgcpComm(mgcNotifReq,					/* mgcp command type	  */
															 epd,							/* endpoint ID			  */
															 NULL,							/* CallId				  */
															 NULL,							/* ConnectionId			  */
															 genNewHexString(),				/* RequestIdentifier	  */
															 NULL,							/* LocalConnectionOptions */
															 "sendrecv",							/* Connection Mode		  */
															 "HU(N)",						/* RequestedEvents		  */
															 " ",							/* SignalRequests		  */
															 NULL,							/* digitMap				  */
															 NULL,							/* ObservedEvents		  */
															 NULL,							/* RemoteConn Descriptor  */
															 NULL );						/* LocalConn Descriptor   */
		
			break;
	     case TimeOut:      			
			 
			 printf("\n!!!TimeOUT : %s!!!\n",epd->gwEndPointId);
			 changCallState( epd->call, Disconnect3);
			 changState( epd, Disconnect3);							 
             sendMgcpComm(mgcDelConn,				/* mgcp command type	  */
						 epd,						/* endpoint ID			  */
						 call->callId,				/* CallId				  */
						 epd->conn->connId,			/* ConnectionId			  */
						 genNewHexString(),			/* RequestIdentifier	  */
						 NULL,						/* LocalConnectionOptions */
						 NULL,						/* Connection Mode		  */
						 NULL,						/* RequestedEvents		  */
						 NULL,						/* SignalRequests		  */
						 NULL,						/* digitMap				  */
						 NULL,						/* ObservedEvents		  */
						 NULL,						/* RemoteConn Descriptor  */
						 NULL);						/* LocalConn Descriptor   */
			  break;

		 case Ack:
			 changCallState( epd->call, WaitReconnect);
			 changState(epd,WaitReconnect);
			 break;
	     default:
	          break;
		}
	     break;
		 //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	 case Reconnect:
         switch(event){
	          case Ack:
				 changCallState( epd->call, Talking1);
			     changState(epd,Talking1);			  
              default:  				  
			      break;
		 }
		 break;
		 //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	}
}


int doPulse(void)
{
    sprintf( logbuf,".");
	PRINT(logbuf);
    return 0;
}

void handleNotify(mgcMsg msg, EndPointData* epd)
{
	static mgcSockAddr rgw2_addr;
	mgcParmStr O = mgcMsgGetParm(msg, "O");
	char* d = O;

	/* if this call have messages in its message queue, it means these messages
	   are not acked yet. We should queue this notify to be proccessed later */
	if ( epd->msgQ->sizeQ!=0 ) {
		printf("\nenter notify queue!!!!!!!\n");
		enterMSGQ( epd->notifyQ, msg);
		return;
	}

	if (contains(O,"HU")||contains(O,"hu"))
		processOnHook( epd, msg);
	else if (contains(O,"HD")||contains(O,"hd"))
		processOffHook( epd, msg);
	else if (contains(O,"BZ")||contains(O,"bz"))
		processBuzy( epd, msg);
	else 
		processDial( epd, msg);
}

void handleRstrInPrgs(EndPointData* epd)
{
	// reInitialize endpoint data
	epd->requestId = NULL;
	epd->requestLine = NULL;

	epd->call = NULL;
	epd->conn = NULL;
	epd->epTalkingto = NULL;
	epd->isOnHook = 1;
	epd->isBuzy = 0;
	epd->sdp = NULL;

	sendMgcpComm(mgcNotifReq,				/* mgcp command type	  */
				 epd,						/* endpoint ID			  */
				 NULL,						/* CallId				  */
				 NULL,						/* ConnectionId			  */
				 genNewHexString(),			/* RequestIdentifier	  */
				 NULL,						/* LocalConnectionOptions */
				 NULL,						/* Connection Mode		  */
				 "HD(N)",					/* RequestedEvents		  */
				 NULL,						/* SignalRequests		  */
				 NULL,						/* digitMap				  */
				 NULL,						/* ObservedEvents		  */
				 NULL,						/* RemoteConn Descriptor  */
				 NULL);						/* LocalConn Descriptor   */
}

void processBuzy(EndPointData* epd, mgcMsg msg)
{
	CALLDATA* call = epd->call;

	switch ( call->callflowState ) {
	case Idle:
	case Dialing:
	case Connecting:

	break;
	case Ringing:
	case Ringtone:
	{	
		epd->isBuzy = 1;
		sendMgcpComm(mgcDelConn,					/* mgcp command type	  */
					 epd,							/* endpoint ID			  */
					 call->callId,					/* CallId				  */
					 epd->conn->connId,				/* ConnectionId			  */
					 genNewHexString(),				/* RequestIdentifier	  */
					 NULL,							/* LocalConnectionOptions */
					 NULL,							/* Connection Mode		  */
					 "HD(N)",						/* RequestedEvents		  */
					 NULL,							/* SignalRequests		  */
					 NULL,							/* digitMap				  */
					 NULL,							/* ObservedEvents		  */
					 NULL,							/* RemoteConn Descriptor  */
					 NULL );						/* LocalConn Descriptor   */
	}
	break;
	case Talking1:
    case Talking2:
	case Disconnect1:
	case Disconnect2:
	case Disconnect:
    default:
	break;
	}
}


void processOnHook(EndPointData* epd, mgcMsg msg)
{
	CALLDATA* call = epd->call;

	/* discare duplicated NTFY HU */
	if ( epd->isOnHook )  
		return;
	epd->isOnHook = 1;
	
	switch ( call->callflowState ) {
	case Idle:
	case Dialing:
	{
		sendMgcpComm(mgcNotifReq,					/* mgcp command type	  */
					 epd,							/* endpoint ID			  */
					 NULL,							/* CallId				  */
					 NULL,							/* ConnectionId			  */
					 genNewHexString(),				/* RequestIdentifier	  */
					 NULL,							/* LocalConnectionOptions */
					 NULL,							/* Connection Mode		  */
					 "HD(N)",						/* RequestedEvents		  */
					 NULL,							/* SignalRequests		  */
					 NULL,							/* digitMap				  */
					 NULL,							/* ObservedEvents		  */
					 NULL,							/* RemoteConn Descriptor  */
					 NULL );						/* LocalConn Descriptor   */
	}
	break;

	case Connecting:
	case Ringing: 
	case Ringtone:
	case Talking1:
	case Talking2:
	{
			sendMgcpComm(mgcDelConn,					/* mgcp command type	  */
						 epd,							/* endpoint ID			  */
						 call->callId,					/* CallId				  */
						 epd->conn->connId,				/* ConnectionId			  */
						 genNewHexString(),				/* RequestIdentifier	  */
						 NULL,							/* LocalConnectionOptions */
						 NULL,							/* Connection Mode		  */
						 "HD(N)",						/* RequestedEvents		  */
						 NULL,							/* SignalRequests		  */
						 NULL,							/* digitMap				  */
						 NULL,							/* ObservedEvents		  */
						 NULL,							/* RemoteConn Descriptor  */
						 NULL );						/* LocalConn Descriptor   */
	}
	break;
		
	case Disconnect1:
	{
	}
	break;

	case Disconnect2:
	{
		/* I don't think this will happen*/
	}
	break;

	case Disconnect://doing
	{
			sendMgcpComm(mgcNotifReq,					/* mgcp command type	  */
						 epd,							/* endpoint ID			  */
						 NULL,							/* CallId				  */
						 NULL,							/* ConnectionId			  */
						 genNewHexString(),				/* RequestIdentifier	  */
						 NULL,							/* LocalConnectionOptions */
						 NULL,							/* Connection Mode		  */
						 "HD(N)",						/* RequestedEvents		  */
						 NULL,							/* SignalRequests		  */
						 NULL,							/* digitMap				  */
						 NULL,							/* ObservedEvents		  */
						 NULL,							/* RemoteConn Descriptor  */
						 NULL );						/* LocalConn Descriptor   */
	}
	break;
	}
}


void processOffHook(EndPointData* epd, mgcMsg msg)
{
	CALLDATA* call;

	epd->isOnHook = 0;

	if ( epd->epState==Idle ) {
		epd->call = createCallData();

		sendMgcpComm(mgcNotifReq,						/* mgcp command type	  */
					 epd,								/* endpoint ID			  */
					 NULL,								/* CallId				  */
					 NULL,								/* ConnectionId			  */
					 genNewHexString(),					/* RequestIdentifier	  */
					 NULL,								/* LocalConnectionOptions */
					 NULL,								/* Connection Mode		  */
					 "HU(N),[0-9T](D)",					/* RequestedEvents		  */
					 "DL",								/* SignalRequests		  */
					 "(XXXXX)",					/* digitMap				  */
					 NULL,								/* ObservedEvents		  */
					 NULL,								/* RemoteConn Descriptor  */
					 NULL);								/* LocalConn Descriptor   */
	}
	else {

		if ( !epd->call ) {
			printf("What are you do???");
		}
			
		call = epd->call;
		switch (call->callflowState) {
		case Ringing: //doing 
		{
			enterMSGQ(epd->msgQ, msg);
		}
		break;

		case Ringtone: 
		{
			if ( epd->msgQ->headQ==NULL ) 
				sendMgcpComm(mgcModConn,				/* mgcp command type	  */
							 epd,						/* endpoint ID			  */
							 call->callId,				/* CallId				  */
							 epd->conn->connId,			/* ConnectionId			  */
							 genNewHexString(),			/* RequestIdentifier	  */
							 NULL,						/* LocalConnectionOptions */
							 NULL,						/* Connection Mode		  */
							 "HU(N)",					/* RequestedEvents		  */
							 NULL,						/* SignalRequests		  */
							 NULL,						/* digitMap				  */
							 NULL,						/* ObservedEvents		  */
							 NULL,						/* RemoteConn Descriptor  */
							 NULL);						/* LocalConn Descriptor   */
			else 
				enterMSGQ( epd->notifyQ, msg); 
		}
		break;

		case Disconnect2:
		{
			/*must queued this notify, but we don't have queue now*/
		}

		default: /* any orther case, discard this notify */
			;
		}
	}
}

void processDial(EndPointData* epd, mgcMsg msg)
{
	EndPointData* ep2;
 	CALLDATA* call= epd->call;
	mgcParmStr O = mgcMsgGetParm(msg, "O");
	char* d = O;
    epd->call->caller = epd->gwEndPointId;// Sharon
   	while ( !isdigit(*d) ) d++; /* d now point to phone number */
	if ( call && call->callflowState==Dialing ) {
		ep2 = mgcHashItem( phones[0], d);
		if (ep2 && ep2->isOnHook==1 && ep2->epState==Idle) { 
			epd->epTalkingto = strdup(ep2->gwEndPointId);
			sendMgcpComm(mgcCreatConn,				/* mgcp command type	  */
						 epd,						/* endpoint ID			  */
						 call->callId,				/* CallId				  */
						 NULL,						/* ConnectionId			  */
						 genNewHexString(),			/* RequestIdentifier	  */
						 epd->localConnOpt,			/* LocalConnectionOptions */
						 "RECVONLY",				/* Connection Mode		  */
						 NULL,						/* RequestedEvents		  */
						 NULL,						/* SignalRequests		  */
						 NULL,						/* digitMap				  */
						 NULL,						/* ObservedEvents		  */
						 NULL,						/* RemoteConn Descriptor  */
						 NULL);						/* LocalConn Descriptor   */
		}
		else {	/* Dialed wrong number or ep2 busy */
			call->callflowState = Disconnect1;
			sendMgcpComm(mgcNotifReq,			/* mgcp command type	  */
						 epd,						/* endpoint ID			  */
						 NULL,						/* CallId				  */
						 NULL,						/* ConnectionId			  */
						 genNewHexString(),			/* RequestIdentifier	  */
						 NULL,						/* LocalConnectionOptions */
						 NULL,						/* Connection Mode		  */
						 "HU(N)",					/* RequestedEvents		  */
						 "E",						/* SignalRequests		  */
						 NULL,						/* digitMap				  */
						 NULL,						/* ObservedEvents		  */
						 NULL,						/* RemoteConn Descriptor  */
						 NULL);						/* LocalConn Descriptor   */
		}
	}
	else
		printf("\n protocol error...!\n");
}

/* returns static copy of string.  dup if needed */
char* genNewHexString(void)
{
    static char buff[33];
    sprintf(buff, "0123456789%X", ++hexSource);
    return buff;
}

/* returns static copy of string.  dup if needed */
char* genNewTId(EndPointData*epd)
{
    static char buff[33];
	tIdSource+=2;
    sprintf(buff, "%d", tIdSource);
    return buff;
}

/* This should report ackType relative to how
 * RGW supports these signals/notifications
 * For now, always returns mgcAckOK (unless looking for on/off hook)
 */
/* ??? RESOLVED -- if already in the desired state, this is a nack 
 *     and the signal and notification state is unchanged.
 * should this reset requestline if already on/off hook
 */
mgcAckType checkSigAndNotify(mgcMsg msg, EndPointData*epd) 
{
    mgcAckType ackType = mgcAckOK;
	mgcMsgType msgType = mgcMsgGetType(msg);
    mgcParmStr R = mgcMsgGetParm(msg, "R");
    mgcParmStr X = mgcMsgGetParm(msg, "X");

    if( (msgType==mgcNotify && epd->epState==Init) || (X==NULL && R!=NULL) ) {
		ackType = mgcAckProtoErr;
    } else if( epd->isOnHook && contains(R, reqOnHook) ) {
		ackType = mgcAckOnHook;
    } else if( !epd->isOnHook && contains(R, reqOffHook) ) {
		ackType = mgcAckOffHook;
    }

    return ackType;
}

void loadEpData(char* file) {
    FILE *f = fopen(file, "r");
    char input[MAXLINE], *p;
	EndPointData* ep;

    if( f==NULL ) usage("initfile not found");

	endpoints[0] = mgcHashNew(20, 0, MGCHASH_POINTER);
	phones[0] = mgcHashNew(10, 0, MGCHASH_POINTER);

    while( (p=fgets(input,MAXLINE,f)) != NULL ) {
		char *phoneNUM, *epID, *gwHost, *gwPort;
		/* first non-blank string is the var */
		while( isspace(*p) ) p++;
		if( *p==0 || *p=='#' || *p=='[') continue;//[xxxx]椣@
		phoneNUM = p;
		while( isalnum(*p) ) p++;
		*p = 0; p++;

		/* skip blanks and = */
		while( isspace(*p) || *p=='=' || *p ==':' ) p++;

		/* rest of line trimmed is the value */
		epID = trimWS(p);

		ep = (EndPointData*)malloc(sizeof(EndPointData));

		ep->phoneNum = strdup(phoneNUM);
		strtok( epID, ":");
		gwPort = strtok( NULL, ":");
		ep->gwEndPointId = strdup(epID);

		strtok( epID, "@");
		gwHost = strtok( NULL, "@");

		ep->gwHost = strdup(gwHost);
		if (gwPort) 
			ep->gwPort = ATOI(gwPort);
		else
			ep->gwPort = 2427;

		ep->requestId = NULL;
		ep->requestLine = NULL;

		ep->call = NULL;
		ep->callhead = NULL;
		ep->timeoutid = 0;
		ep->conn = NULL;
		ep->epTalkingto = NULL;
		changState(ep,Init);
		ep->isOnHook = 1;
		ep->isBuzy = 0;
		ep->localConnOpt = strdup(getInitVar("localConnOption"));
		ep->sdp = NULL;

		//mgcHashAdd(endpoints[j], endPointId, ep);
		mgcHashAdd(endpoints[0], ep->gwEndPointId, ep);
		mgcHashAdd(phones[0], ep->phoneNum, ep);
		epPhoneNums[epCount] = strdup(phoneNUM);

		/* initial message queue for this endpoint */
		ep->msgQ = (struct MSGQ*)malloc(sizeof(struct MSGQ));
		ep->msgQ->headQ = NULL;
		ep->msgQ->tailQ = NULL;
		ep->msgQ->sizeQ = 0;
		/* initial notify queue for this endpoint */
		ep->notifyQ = (struct MSGQ*)malloc(sizeof(struct MSGQ));
		ep->notifyQ->headQ = NULL;
		ep->notifyQ->tailQ = NULL;
		ep->notifyQ->sizeQ = 0;

		ep->proccessQ = 0;
		ep->latestTId = 0;				/* used to control call flow */

		epCount++;
	}
	mgcHashAdd(endpoints[0], "*", NULL); /* for wildcard */
}

CALLDATA* createCallData()
{
	CALLDATA* call = (CALLDATA*) malloc(sizeof(CALLDATA));

	call->callId = genNewHexString();
	call->callflowState = Idle;
	call->caller = NULL;
	call->callee = NULL;
	call->timeoutid = 0;
	call->callernext = NULL;
	call->calleenext = NULL;
	return call;
}

void destoryCallData(CALLDATA* call)
{
	if (call) free(call);
	call = NULL;
}

CALLDATA* nextcall(EndPointData* epd, CALLDATA* call)
{
	if (!strcmp(epd->gwEndPointId, call->caller)) {
		return call->callernext;
	}
	else {
		return call->calleenext;
	}
}

void deletecall(EndPointData* epd, CALLDATA* call)
{
	CALLDATA* ptr;
	ptr = epd->callhead;
	if (!call) {
		return;
	}
	if (!nextcall(epd, ptr) && (ptr == call)) {
		epd->call = NULL;
		epd->callhead = NULL;
		return;
	}
	if (ptr == call) {
		epd->callhead = nextcall(epd, epd->callhead);
		epd->call = epd->callhead;
		return;
	}
	while(ptr) {
		if (nextcall(epd, ptr) == call)
			break;
		ptr = nextcall(epd, ptr);
	}
	if (ptr) {
		if (!strcmp(epd->gwEndPointId, ptr->caller)) {
			ptr->callernext = nextcall(epd,nextcall(epd,ptr));
		}
		else {
			ptr->calleenext = nextcall(epd,nextcall(epd,ptr));
		}
		epd->call = ptr;
	}
	return;
}

int enterTimeOut( EndPointData* epd, long delayTime ) {
    struct timeval t = { delayTime/1000000, delayTime%1000000 };
    return mgcAlarmSet( t, doTimeOut, epd );
}
void doTimeOut( EndPointData* epd, int id) {
	mgcMsg msg;	
	epd->timeoutid = id;
    processCallFlow( epd, TimeOut, msg);    
}

struct CONNDATA* createConnData()
{
	struct CONNDATA* conn = (struct CONNDATA*) malloc(sizeof(struct CONNDATA));

	conn->connId = NULL;
	conn->mode = NULL;
	conn->next = NULL;

	return conn;
}

void destoryConnData(struct CONNDATA* conn)
{
	free(conn);
}

void loadInitVars(char* file) {
    FILE *f = fopen(file, "r");
    char input[MAXLINE], *p;
    if( f==NULL ) usage("initfile not found");

    initVars=mgcHashNew(32, 1, MGCHASH_CSTRING);
	//initVars=mgcHashNew(20, 1, MGCHASH_CSTRING);
    while( (p=fgets(input,MAXLINE,f)) != NULL ) {
		char *var, *val;
		/* first non-blank string is the var */
		while( isspace(*p) ) p++;
		if( *p==0 || *p=='#' || *p=='[') continue;//[xxxx]椣@
		var = p;
		while( isalnum(*p) ) p++;
		*p = 0; p++;

		/* skip blanks and = */
		while( isspace(*p) || *p=='=' || *p ==':' ) p++;

		/* rest of line trimmed is the value */
		val = trimWS(p);

		mgcHashAdd(initVars, var, val);	
    }
}

char* getInitVar(char* var) 
{
    char *p = mgcHashItem(initVars, var);
    if( p==NULL ) return "";
    return p;
}

static void usage(char *msg)
{
    if( msg != NULL ) {
		printf("\n%s\n\n", msg);
    }

    printf("\n%s needs parameters taken from an initfile, where\n",
	   progName);

    printf(
	   "\ninitfile contains the following initialization parameters\n"
	   "	prefix = n	local prefix\n"
	   "	start = n	first extension\n"
	   "	stop =  n	last extension\n"
	   "	delay = uuu	initial delay between resends in usecs (min 50000)\n"
	   "	trace = 1	if >1, additional trace info printed\n"
	   "	log = 1	if != 0, additional trace info printed\n"
	   "	phHost=host.dom	domain name of Phone host\n"
	   "	phPort = pppp	Phone port on phHost\n"
	   "	gwHost=host.dom	domain name of RGW host\n"
	   "	gwPort = pppp	RGW port\n"
	   "	vatHost=h.dom	domain name of VAT(RTP) host\n"
	   "	vatPort= ppp	VAT(RTP) port on vatHost\n"
	   "	caHost=host.dom	domain name of CA host\n"
	   "	caPort = pppp	CA port on caHost\n"
	   "Variable names are not case sensitive.\n"
	   "Values are blank trimmed.\n"
	   "Currently extension and prefix are single digits\n"
	   "\n"
	);
    exit(1);
}

void changState(EndPointData* epd, stateType st)
{	
    time_t ltime;
    struct tm *today;

	epd->epState = st;

	TRACE(1)
	
    time( &ltime );
    today = localtime( &ltime );
	sprintf(logbuf, "\n<time> =\t\t%s", asctime( today )  );
	PRINT(logbuf);
	sprintf(logbuf, "Endpoint [%s], State =  <%s>\n", epd->gwEndPointId, StateType[epd->epState]);
	PRINT(logbuf);
////////////////////////////////////////////for UI
	if(isUIon==TRUE)
		msgtoUI(epd);//Send Message to User Interface
/////////////////////////////////////////////////////////
	endTRACE(1)
}

void changCallState(CALLDATA* cld, stateType st)
{
	cld->callflowState = st;
}

int sendMgcpComm(mgcMsgType msg, EndPointData* epd, char* C, char* I, char* X, char* L,
			 char* M, char* R, char* S, char* D, char* O, char* RC, char* LC)
{
	mgcSockAddr dst_addr;
	mgcMsg mgcComm;
	char* tid;

	if ( epd==NULL ) 
		return 0;
	dst_addr = mgcSockAddrNewDom(epd->gwHost, epd->gwPort);
	if( dst_addr == NULL) return -1;
	
	mgcComm = mgcMsgNew(msg);
	mgcMsgSetEPt(mgcComm,epd->gwEndPointId);
	tid = genNewTId(epd);
	mgcMsgSetTId(mgcComm,tid);

	if (C) mgcMsgAddParm(mgcComm, "C", C);
	if (I) mgcMsgAddParm(mgcComm, "I", I);
	if (X) mgcMsgAddParm(mgcComm, "X", X);
	if (L) mgcMsgAddParm(mgcComm, "L", L);
	if (M) mgcMsgAddParm(mgcComm, "M", M);
	if (R) mgcMsgAddParm(mgcComm, "R", R);
	if (S) mgcMsgAddParm(mgcComm, "S", S);
	if (D) mgcMsgAddParm(mgcComm, "D", D);
	if (O) mgcMsgAddParm(mgcComm, "O", O);
	if (RC) mgcMsgSetSDP(mgcComm, RC);
	if (LC) mgcMsgSetSDP(mgcComm, LC);

	enterMSGQ(epd->msgQ,mgcComm);
	epd->latestTId = ATOI(tid);

	mgcMsgSend(mgcComm, dst_addr);
	mgcHashAdd(tidLog[0], tid, epd);

	//\nMSGQ size=%d\n, epd->msgQ->sizeQ

	TRACE(1)
	sprintf(logbuf, "Send MSG ==>{%s}\n",
			 mgcStrAsCStr(mgcMsgAsStr(mgcComm)) );
	PRINT(logbuf);
	endTRACE(1)

	return 1;
}
