/* 
 * Copyright (C) 2000-2001 Computer & Communications Research Laboratories,
 *			   Industrial Technology Research Institute
 */
/*
 * utils.h
 *
 * $Id: utils.h,v 1.14 2001/06/12 00:43:02 hcc Exp $
 */

#ifndef UTILITIES_H
#define UTILITIES_H

#include <stdlib.h>

#define MAXFIELD 100

#ifdef  __cplusplus
extern "C" {
#endif

#define MIN(a,b)	((a>=b)?b:a)
#define MAX(a,b)	((a>=b)?a:b)

/* return string rep of integer i
 * string is in static memory, so it must be copied before another is
 * converted
 */
char* i2a(int x, char* buf, int buflen);

#ifndef a2i
#define a2i(x) ((x)?atoi(x):0)
#endif

char* trimWS(char * s);

char* quote(char* s);

char* unquote(char* s);

/* return true if pattern appears in s */
int strCon(char* s, char* pattern);

/* case-insensitive version of strCon() */
int strICon(char* s, char* pattern);

/* string case-insensitive compare */
int strICmp(const char* s1, const char* s2);

/* string case-insensitive n charactors compare */
int strICmpN(const char* s1, const char* s2, int n);

/* strDup, use malloc() to duplicate string s. 
   User should use free() to deallocate memory. */
char* strDup(const char* s);

#ifdef  __cplusplus
}
#endif

#endif /* UTILITIES_H */

