/* 
 * Copyright (C) 1999-2001 Computer & Communications Research Laboratories,
 *			   Industrial Technology Research Institute
 */
/*
 * msgSock.h
 *
 * $Id: msgSock.h,v 1.13 2001/06/15 08:14:10 sjtsai Exp $
 */

#ifndef MSGSOCK_H
#define MSGSOCK_H

#ifdef  __cplusplus
extern "C" {
#endif

#include "common.h"
#include "tracer.h"

#ifdef WIN32
#include <winsock.h>
#endif

typedef struct msgSockAddrObj	*msgSockAddr;
typedef struct msgSockObj	*msgSock;

typedef enum 
{
	msgSockUnknown=0,
	msgSockDgram,
	msgSockServer,
	msgSockStreamC,
	msgSockStreamS
} msgSockType;

void		msgLibInit(void);
void		msgLibClean(void);

msgSockAddr	msgSockAddrNew(const char* addr, UINT16 port);
void		msgSockAddrFree(msgSockAddr);
msgSockAddr	msgSockAddrDup(msgSockAddr);
char*		msgSockAddrGetAddr(msgSockAddr);
UINT16		msgSockAddrGetPort(msgSockAddr);

msgSock		msgSockNew(msgSockType, msgSockAddr laddr);
void		msgSockFree(msgSock);
SOCKET		msgSockGetSock(msgSock);
void		msgSockSetSock(msgSock, SOCKET s);
msgSockAddr	msgSockGetLaddr(msgSock);
void		msgSockSetLaddr(msgSock, msgSockAddr laddr);
msgSockAddr	msgSockGetRaddr(msgSock);
void		msgSockSetRaddr(msgSock, msgSockAddr raddr);
msgSock		msgSockAccept(msgSock);
int		msgSockConnect(msgSock, msgSockAddr raddr);
int		msgSockSend(msgSock, const char* buf, int len);
int		msgSockRecv(msgSock, char* buf, int len);
int		msgSockTpktSend(msgSock, const char* buf, int len);
int		msgSockTpktRecv(msgSock, char* buf, int len);
int		msgSockSendto(msgSock, const char* buf, int len, msgSockAddr raddr);
int		msgSockRecvfrom(msgSock, char* buf, int len);

/*========================================================================
 * msgSock Trace module
 *	!!! [Important]  
 *	!!!	Set tracer to NULL before you call TCREnd(). 
 *
 * 	TCR trace level 0 : log nothing 
 *	TCR trace level 1 : log errors only
 *	TCR trace level 2 : log all detial records
 */
void	msgSockSetTracer(TCR tracer);

TCR	msgSockGetTracer(void);


#ifdef  __cplusplus
}
#endif

#endif /* MSGSOCK_H */
