/* 
 * Copyright (C) 2000-2001 Computer & Communications Research Laboratories,
 *			   Industrial Technology Research Institute
 */
/* Copyright Telcordia Technologies 1999 */
/*
 * msgAlarm.h
 *
 * $Id: msgAlarm.h,v 1.13 2001/06/15 08:14:10 sjtsai Exp $
 */

#ifndef MSGALARM_H
#define MSGALARM_H

#include "tracer.h"

#ifdef  __cplusplus
extern "C" {
#endif

#if defined(UNIX)
#include <sys/time.h>
#elif defined(WIN32)
#include <winsock.h> /* timeval */
#endif

typedef void (*msgAlarmCB)(void*);

/* MUST be called before any other msgAlarm routines.
 * Allocates room for maxevents events waiting at one time.
 */
void msgAlarmInit(int maxEvents);
void msgAlarmClean(void);

/* create an alarm to occur after delay.  On the alarm, call cb(data).
 * Returns an alarm id used by msgAlarmDel to cancel an alarm.
 *
 * data is the responsibility of the creator of the alarm.  
 * It must either be deallocated by cb or when the event is deleted with
 * msgAlarmDel
 */
int msgAlarmSet(struct timeval delay, msgAlarmCB cb, void* data);

/* Remove alarm e from future events.  
 * Returns associated data, in case it needs to be managed
 */
void *msgAlarmDel(int e);

/* block/release occurrences of alarm.  
 * these are cumulative and may be nested 
 */
/*#ifdef UNIX
void msgAlarmHold(void);
void msgAlarmRelease(void);
#endif*/

/*========================================================================
 * msgAlarm Trace module
 *	!!! [Important]  
 *	!!!	Set tracer to NULL before you call TCREnd(). 
 *
 * 	TCR trace level 0 : log nothing 
 *	TCR trace level 1 : log errors only
 *	TCR trace level 2 : log all detial records
 */
void	msgAlarmSetTracer(TCR tracer);

TCR	msgAlarmGetTracer(void);

#ifdef  __cplusplus
}
#endif

#endif /* MSGALARM_H */

