/* 
 * Copyright (C) 2000-2001 Computer & Communications Research Laboratories,
 *			   Industrial Technology Research Institute
 */
/*
 * lowSync.h
 *
 * $Id: lowSync.h,v 1.15 2001/06/12 00:39:13 hcc Exp $
 */

#ifndef LOWSYNC_H
#define LOWSYNC_H

#ifdef  __cplusplus
extern "C" {
#endif

typedef enum {
	MUTEX_INTERTHREAD,
	MUTEX_INTERPROCESS
} mutexType;

typedef struct lowMutexObj* lowMutex;


/*****************************************************************************
lowMutexNew(mutexType, int key)
	when type==MUTEX_INTERTHREAD, the key value is ignored.
	when type==MUTEX_INTERPROCESS, the key value is used for other process
	to obtain this mutex.
******************************************************************************/
lowMutex	lowMutexNew(mutexType, int key);

/*****************************************************************************
lowMutexLock(lowMutex)
	This will block current thread, if the mutex is owned by other threads
	now.
******************************************************************************/
int		lowMutexLock(lowMutex);

int		lowMutexUnlock(lowMutex);

void		lowMutexFree(lowMutex);

#ifdef __cplusplus
}
#endif

#endif /*LOWSYNC_H*/

