/* 
 * Copyright (C) 2000-2001 Computer & Communications Research Laboratories,
 *			   Industrial Technology Research Institute
 */
/*
 * adtVector.h
 *
 * $Id: adtVector.h,v 1.8 2001/06/21 02:48:46 sjtsai Exp $
 */
#include "common.h"
#include "tracer.h"

#ifndef VECTOR_H
#define VECTOR_H

typedef enum
{
	V_POINTER = 0,
	V_INTEGER,
	V_STRING
} adtVectorType;

typedef struct adtVectorObj*	adtVector;

#ifdef  __cplusplus
extern "C" {
#endif

adtVector	adtVectorNew(int,adtVectorType);/*size*/
void		adtVectorFree(adtVector,void(*elementFreeCB)(void*));
adtVector  	adtVectorDup(adtVector,void*(*elementDupCB)(void*));
int		adtVectorGetSize(adtVector);

/*========================================================================
// add element to tail of vecter*/
RETCODE		adtVectorAddElement(adtVector,void* elemt);

/*========================================================================
// add element to a specific position of adtVector*/
RETCODE		adtVectorAddElementAt(adtVector,void* elemt,int position);

/*========================================================================
// get element at the tail of vecter*/
void*		adtVectorGetElement(adtVector);

/*========================================================================
// get index of element,search from given index*/
int		adtVectorGetIndexOf(adtVector,void* elemt,int position);

/*========================================================================
// get index of element,search backward from given index*/
int		adtVectorGetlastIndexOf(adtVector,void* elemt,int position);

/*========================================================================
// get element at a specific position of vecter*/
void*		adtVectorGetElementAt(adtVector,int position);

/*========================================================================
// Removes the first occurrence of the argument from this adtVector*/
RETCODE		adtVectorRemoveElement(adtVector,void* elemt);

/*========================================================================
// add element at a specific position of vecter*/
void*		adtVectorRemoveElementAt(adtVector,int position);

/*========================================================================
// set this vector's trace flag TRACE_ON or TRACE_OFF*/
void		adtVectorSetTraceFlag(adtVector,TRACE_FLAG traceflag);



/*========================================================================
 * adtVector Trace module
 *	!!! [Important]  
 *	!!!	Set tracer to NULL before you call TCREnd(). 
 *
 * 	TCR trace level 0 : log nothing 
 *	TCR trace level 1 : log errors only
 *	TCR trace level 2 : log all detial records
 */
void		adtVectorSetTracer(TCR tracer);

TCR		adtVectorGetTracer(void);


#ifdef  __cplusplus
}
#endif


#endif /*VECTOR_H*/
