/* 
 * Copyright (C) 2000-2001 Computer & Communications Research Laboratories,
 *			   Industrial Technology Research Institute
 */
/*
 * adtMsgQ.h
 *
 * $Id: adtMsgQ.h,v 1.5 2001/06/15 08:14:10 sjtsai Exp $
 */

#ifndef MSGQ_H
#define MSGQ_H

#include "tracer.h"
#include "adtVector.h"

typedef struct adtMsgQObj* adtMsgQ;

#ifdef  __cplusplus
extern "C" {
#endif

adtMsgQ adtMsgQNew(int mq_size);

void adtMsgQFree(adtMsgQ mq);

int adtMsgQGetLen(adtMsgQ mq);

int adtMsgQSendMsg(adtMsgQ mq,char* msg,unsigned int len);

int adtMsgQGetMsg(adtMsgQ mq,char* msg,int len,unsigned long timeout);

/*========================================================================
// set this adtMsgQ's trace flag ON or OFF*/
void	adtMsgQSetTraceFlag(adtMsgQ mq,TRACE_FLAG);

/*========================================================================
 * adtMsgQ Trace module
 *	!!! [Important]  
 *	!!!	Set tracer to NULL before you call TCREnd(). 
 *
 * 	TCR trace level 0 : log nothing 
 *	TCR trace level 1 : log errors only
 *	TCR trace level 2 : log all detial records
 */
void		adtMsgQSetTracer(TCR tracer);

TCR		adtMsgQGetTracer(void);


#ifdef  __cplusplus
}
#endif


#endif
