/* 
 * Copyright (C) 2000-2001 Computer & Communications Research Laboratories,
 *			   Industrial Technology Research Institute
 */
/*
 * adtBuffer.h
 *
 * $Id: adtBuffer.h,v 1.9 2001/06/21 02:48:46 sjtsai Exp $
 */

#ifndef ADTBUFFER_H
#define ADTBUFFER_H


#ifdef  __cplusplus
extern "C" {
#endif

#include "common.h"
#include "tracer.h"

typedef struct adtBufferObj* 	adtBuffer;

adtBuffer	adtBufferNew(int size);
void		adtBufferFree(adtBuffer);
adtBuffer	adtBufferDup(adtBuffer);
void		adtBufferClear(adtBuffer);
int		adtBufferRead(adtBuffer,char* buff,int len);
int		adtBufferWrite(adtBuffer,char* buff,int len);

/*========================================================================
// set this adtMsgQ's trace flag ON or OFF*/
void	adtBufferSetTraceFlag(adtBuffer,TRACE_FLAG);

/*========================================================================
 * adtBuffer Trace module
 *	!!! [Important]  
 *	!!!	Set tracer to NULL before you call TCREnd(). 
 *
 * 	TCR trace level 0 : log nothing 
 *	TCR trace level 1 : log errors only
 *	TCR trace level 2 : log all detial records
 */
void		adtBufferSetTracer(TCR tracer);

TCR		adtBufferGetTracer(void);


#ifdef  __cplusplus
}
#endif


#endif /*ADTBUFFER_H*/

