/*=========================================================================*\
  Copyright (c) 2000-2001 Computer & Communications Research Laboratories,
                          Industrial Technology Research Institute
  
  RTP helper 
  
  Author: Jiun-Yao Huang <jyhuang@wizs.org>
  Revision: $Id: rtp_helper.h,v 1.9 2001/06/15 10:40:48 jyhuang Exp $
  Description:
\*=========================================================================*/
#ifndef	__RTP_HELPER_H__
#define	__RTP_HELPER_H__

#include "rtp.h"

/* debug/trace function */
#ifdef	NDEBUG
#ifdef	__GNUC__
#define	rtptrace(fmt, arg...)	((void) 0)
#else	/* !__GNUC */
void rtptrace(char *fmt, ...);
#endif	/* __GNU__ */
#else /* !NDEBUG */
#include <stdio.h>
#include <stdarg.h>
void rtptrace(char *fmt, ...);
#endif

/* helper functions for resource list */
void __srclist_init(rtp_source_list_t *srcs);
rtp_source_t *__srclist_lookup(rtp_source_list_t *srcs, u_int32 ssrc);
rtp_source_t *__srclist_add(rtp_source_list_t *srcs, u_int32 ssrc);
void __srclist_free(rtp_source_list_t *srcs);

u_int16 __rtp_random(void);

/* a simple function that generates SSRC */
u_int32 __gen_ssrc(void);

int __getipaddr(const char *addrstr, struct in_addr *addr);

#endif /* #ifndef __RTP_HELPER_H__ */
