/* 
 * Copyright (C) 2000-2001 Computer & Communications Research Laboratories,
 *			   Industrial Technology Research Institute
 */
/*
 * cclRtp.h
 *
 * $Id: cclRtp.h,v 1.6 2001/06/21 02:56:09 hcc Exp $
 */

#ifndef CCLRTP_H
#define CCLRTP_H

#include "common.h"
#include "rtp.h"

#ifdef  __cplusplus
extern "C" {
#endif

RETCODE	cclRTPStartup(int maxRtpChans);

void	cclRTPCleanup(void);

/* cclRTPOpen()
	#channel>=0 and #channel<MAX_RTP_CHANS
	RETCODE < 0 : error
	RETCODE = 0 : success
	RETCODE > 0 : already opened, new #rtpPacketSiz will
		      take effort.
 */
RETCODE	cclRTPOpen(int channel, int rtpPacketSiz);

RETCODE	cclRTPClose(int channel);

UINT32	cclRTPGetPort(int channel);

RETCODE	cclRTPGetRR(int channel, rtcp_rr_t* rr);

void	cclRTPSetEventHandler( int(*rtpReadCB)(int,const char*,int) );

RETCODE	cclRTPWrite(int channel, const char* buff, int len);

RETCODE	cclRTPSetPeerAddr(int channel, char* addr, int port);

#ifdef  __cplusplus
}
#endif

#endif /* CCLRTP_H */