/* 
 * Copyright (C) 2000-2001 Computer & Communications Research Laboratories,
 *			   Industrial Technology Research Institute
 */
/*
 * utils.c
 *
 * $Id: utils.c,v 1.13 2001/06/13 08:29:27 hcc Exp $
 */

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include "utils.h"

/* return string rep of integer i
 * string is in static memory, so it must be copied before another is
 * converted
 */
char* i2a(int x, char* buf, int buflen) 
{	
	char temp[12];

	if(!buf||buflen<0)
		return NULL;

	sprintf(temp,"%d",x);
	if( strlen(temp)<(unsigned int)buflen )
		strcpy(buf,temp);
	else 
		return NULL;

	return buf;
}

/*
char* stratt(char*dst,char*src)
{
	char* buff = NULL;

	if ( !dst && !src )
		return NULL;
	else if ( !dst )
		return src;
	else if ( !src )
		return dst;

	buff = (char*)malloc( (strlen(dst)+strlen(src)+1)*sizeof(char) );

	sprintf(buff,"%s%s",dst,src);
	buff[(strlen(dst)+strlen(src)+1)]='\0';

	return buff;
}*/

/* copy string s, mapping to uppercase */
char* copyUp(char* src, char* dst, int dstlen)
{
	/*char* copy;*/
	char* c;

	if( src==NULL || dst==NULL || dstlen<(int)strlen(src) ) 
		return NULL;

	/*copy = malloc(strlen(s)+1);*/
	c = dst;

	while( ((*c++)=toupper(*src++)) != 0 );

	return dst;
}

/* return true if pattern appears in s */
/* ??? check and see if strstr is reasonably efficient 
 * probably will be replaced by simple data structure
 */
int strCon(char* s, char* pattern)
{
	return s!=NULL && strstr(s,pattern) != NULL;
}

int strICon(char* s, char* pattern)
{
	char	*aa,*bb;
	int	ret;

	if( !s||!pattern ) return 0;

	aa = copyUp(s,strDup(s),strlen(s));
	bb = copyUp(pattern,strDup(pattern),strlen(pattern));
	ret = ( strstr(aa,bb)!=NULL );
	free(aa);	free(bb);

	return ret;
}

/* remove whitespace from beginning and end of p, moving characters forward
 * returns p
 */
char* trimWS(char*s)
{
    char* pre;
    char* t;

    if( s==NULL ) return s;
    
    pre = s;
    while( isspace((int)(*pre)) ) pre++;	/* NB !isspace('\0') */
    if( pre>s ) strcpy(s,pre);

    t = s+strlen(s);			/* start t at EOS */
    while( s<t && isspace((int)*(t-1)) )	/* if preceding is space, trim */
		t--;

    *t = 0;
    return s;
}

char* quote(char* s)
{
	char	*quoted;

	if( !s )		return NULL;
	if( strlen(s)>1021 )	return NULL;

	quoted = (char*)malloc(strlen(s)+3);
	quoted[0] = 0;
	strcat(quoted,"\"");
	strcat(quoted,s);
	strcat(quoted,"\"");
	strcpy(s,quoted);
	free(quoted);

	return s;
}

char* unquote(char* s)
{
	char		*unquoted = NULL;
	char		*tail;

	if( !s )		return NULL;
	if( strlen(s)>1023 )	return NULL;

	unquoted = s;
	while( *unquoted==' ' ) unquoted++;
	if( *unquoted=='\"' ) unquoted++;
	if( unquoted>s ) strcpy(s,unquoted);

	tail = s+strlen(s);			/* start tail at EOS */ 
	while( s<tail && isspace((int)*(tail-1)) )	/* if preceding is space, trim */
		tail--;
	if( *(tail-1)=='\"' )	tail--; 
	*tail = 0;

	return s;
}

int strICmp(const char* s1, const char* s2)
{
	char*	aa;
	char*	bb;
	int	result;

	if( !s1 || !s2 )
		return -1;
		
	aa = copyUp((char*)s1,strDup(s1),strlen(s1));
	bb = copyUp((char*)s2,strDup(s2),strlen(s2));
	result = strcmp(aa,bb);

	free(aa);
	free(bb);

	return result;
}

int strICmpN(const char* s1, const char* s2, int n)
{
	char*	aa;
	char*	bb;
	int	result;

	if( !s1 || !s2 )
		return -1;
		
	aa = copyUp((char*)s1,strDup(s1),strlen(s1));
	bb = copyUp((char*)s2,strDup(s2),strlen(s2));
	result = strncmp(aa,bb,n);

	free(aa);
	free(bb);

	return result;	
}

char* strDup(const char* s)
{
	return (s)?strcpy((char*)malloc(strlen(s)+1),s):NULL;
}

