/* 
 * Copyright (C) 2000-2001 Computer & Communications Research Laboratories,
 *			   Industrial Technology Research Institute
 */
/*
 * tracer.h
 *
 * $Id: tracer.h,v 1.3 2001/06/21 02:56:09 hcc Exp $
 */

#ifndef TRACER_H
#define TRACER_H

#include "common.h"

#ifdef  __cplusplus
extern "C" {
#endif

#define	TCRMAXBUFLEN	10000

typedef int TRACE_FLAG;
#define	TRACE_ON	1
#define	TRACE_OFF	0

typedef struct TCRObj	*TCR;	/* tracer */

/* TCRNew()
	By default, all loggers are OFF. trace_level = 0
*/
TCR		TCRBegin(void);
void		TCREnd(TCR);
RETCODE		TCRSetTraceLevel(TCR,int trace_level);
int		TCRGetTraceLevel(TCR);	
	
/* TCRSetMsgCB()
	TCR will callback #msgCB when it gets any message.
	Set #msgCB=NULL to disable callback function.
*/
RETCODE		TCRSetMsgCB(TCR, void(*msgCB)(const char*));

/* TCRSockLoggerON()
	Log to remote via UDP.
*/
RETCODE		TCRSockLoggerON(TCR, const char* raddr, UINT16 rport);
RETCODE		TCRSockLoggerOFF(TCR);

/* TCRSockServerON()
	when SockServer is ON, tracer will receive UDP packet from
	#port, and log it to any logger that is active. 
*/
RETCODE		TCRSockServerON(TCR, UINT16 port);
RETCODE		TCRSockServerOFF(TCR);

RETCODE		TCRConsoleLoggerON(TCR);
RETCODE		TCRConsoleLoggerOFF(TCR);

RETCODE		TCRFileLoggerON(TCR, const char* fname);
RETCODE		TCRFileLoggerOFF(TCR);

/* TCRPrint()
	this function acts just like printf().
*/
int		TCRPrint(TCR,int level, const char* format, ...);



#ifdef  __cplusplus
}
#endif

#endif
