/* 
 * Copyright (C) 2000-2001 Computer & Communications Research Laboratories,
 *			   Industrial Technology Research Institute
 */
/*
 * thread.h
 *
 * $Id: thread.h,v 1.9 2001/06/21 02:56:09 hcc Exp $
 */
 
#ifndef THREAD_H
#define THREAD_H

#ifdef  __cplusplus
extern "C" {
#endif
 
typedef	struct threadObj*	thread;
 
 
/*****************************************************************************
thread	threadCreat(void *(*thread_routine, void*),void *arg)
	use all default attributes to create thread.
****************************************************************************/
thread	threadCreate(void*(*thread_routine)(void*),void *arg);

/*****************************************************************************
RETCODE threadJoin(thread)
	wait for this thread to terminate.
****************************************************************************/
RETCODE threadJoin(thread);

/*****************************************************************************
RETCODE threadCancel(thread)
	Cancel thr execution of this thread.and cleanup all resources used
	by thread.
	ps.	For WIN32, call _endthreadex(),
		for UNIX, call pthread_cancle().
****************************************************************************/
RETCODE threadCancel(thread);

 
#ifdef __cplusplus
}
#endif

#endif /*THREAD_H*/ 
 
 
