/* 
 * Copyright (C) 2000-2001 Computer & Communications Research Laboratories,
 *			   Industrial Technology Research Institute
 */
/*
 * common.h
 *
 * $Id: common.h,v 1.16 2001/06/21 02:56:09 hcc Exp $
 */

#ifndef COMMON_H
#define COMMON_H

#ifdef WIN32
#include <windows.h>
#define CCLAPI			__declspec(dllexport)
#else
#define CCLAPI 
#endif

#ifdef UNIX
typedef int			SOCKET;
typedef void (TIMECALLBACK)(int);
#define INVALID_SOCKET		-1
#define SOCKET_ERROR		-1
#endif

/**************** Basic Types ****************/
#ifndef BOOL
typedef int			BOOL;
#endif

#ifndef TRUE
#define TRUE			1
#endif

#ifndef FALSE
#define FALSE			0
#endif

typedef char			INT8;
typedef short			INT16;
typedef int			INT32;
typedef unsigned char		UINT8;
typedef unsigned short		UINT16;
typedef unsigned int		UINT32;

/*************** return codes ****************/
typedef int			RETCODE;

/* general & common error codes */
#define SUCCESS			0
#define FAIL			-1

#define E_BASEERR		1000
#define E_PARAMETER		(E_BASEERR+1) /* general parameter error */

/* module specific error codes */
#define E_BASEERR_SIP		(E_BASEERR+2000)
#define E_BASEERR_MEGACO	(E_BASEERR+3000)
#define E_BASEERR_SDP		(E_BASEERR+4000)

/* POSIX & non-POSIX system defined error codes */
#ifdef WIN32
#define	EWOULDBLOCK		WSAEWOULDBLOCK

#define	ENOTSOCK		WSAENOTSOCK
#define	EDESTADDRREQ		WSAEDESTADDRREQ
#define	EMSGSIZE		WSAEMSGSIZE
#define	EPROTOTYPE		WSAEPROTOTYPE
#define	ENOPROTOOPT		WSAENOPROTOOPT
#define	EPROTONOSUPPORT		WSAEPROTONOSUPPORT	
#define	ESOCKTNOSUPPORT		WSAESOCKTNOSUPPORT
#define	EOPNOTSUPP		WSAEOPNOTSUPP
#define	EPFNOSUPPORT		WSAEPFNOSUPPORT
#define	EAFNOSUPPORT		WSAEAFNOSUPPORT
#define	EADDRINUSE		WSAEADDRINUSE
#define	EADDRNOTAVAIL		WSAEADDRNOTAVAIL

#define	ENETDOWN		WSAENETDOWN
#define	ENETUNREACH		WSAENETUNREACH
#define	ENETRESET		WSAENETRESET
#define	ECONNABORTED		WSAECONNABORTED
#define	ECONNRESET		WSAECONNRESET
#define	ENOBUFS			WSAENOBUFS
#define	EISCONN			WSAEISCONN
#define	ENOTCONN		WSAENOTCONN
#define	ESHUTDOWN		WSAESHUTDOWN
#define	ETOOMANYREFS		WSAETOOMANYREFS
#define	ETIMEDOUT		WSAETIMEDOUT
#define	ECONNREFUSED		WSAECONNREFUSED
#define	EHOSTDOWN		WSAEHOSTDOWN
#define	EHOSTUNREACH		WSAEHOSTUNREACH
#define	EALREADY		WSAEALREADY
#define	EINPROGRESS		WSAEINPROGRESS
#endif /* WIN32 */

#endif /* COMMON_H */
