/* 
 * Copyright (C) 2000-2001 Computer & Communications Research Laboratories,
 *			   Industrial Technology Research Institute
 */
/* Copyright Telcordia Technologies 1999 */
/*
 * adtStr.h
 *
 * $Id: adtStr.h,v 1.2 2001/06/12 00:36:55 hcc Exp $
 */

#ifndef ADTSTR_H
#define ADTSTR_H

typedef struct adtStrObj *adtStr;

#ifdef  __cplusplus
extern "C" {
#endif

adtStr adtStrNew(void);			/* allocate a new String */
int  adtStrLen(adtStr);			/* length of string */
void adtStrClr(adtStr);	        /* set String to "" */
void adtStrFree(adtStr);			/* De-allocate String */
void adtStrCat(adtStr, char*);		/* Append second arg to String */
void adtStrCatN(adtStr, char*, int);	/* Append N character to String */
char*adtStrAsCStr(adtStr);			/* return char* version of String */
/* WARNING: adtStrAsCStr does NOT return a copy.  That is the callers responsibility */

#ifdef  __cplusplus
}
#endif

#define MINALLOC    200

#endif /* ADTSTR_H */
