/* 
 * Copyright (C) 2000-2001 Computer & Communications Research Laboratories,
 *			   Industrial Technology Research Institute
 */
/* Copyright Telcordia Technologies 1999 */
/*
 * adtHash.h
 *
 * $Id: adtHash.h,v 1.4 2001/06/15 08:14:10 sjtsai Exp $
 */

#ifndef ADTHASH_H
#define ADTHASH_H

#include "tracer.h"

typedef struct adtHashObj *adtHash;
typedef enum 
{
	HASH_POINTER=10, 
	HASH_CSTRING, 
	HASH_INT
} adtHashType;

#ifdef  __cplusplus
extern "C" {
#endif

/* create new hashtable
 * initSize = number of entries in table (may grow)
 * keysUpper: bool should keys be mapped to upper case
 * strings: adtHashType   should val be copied (cstrings and ints)
 *                 by adtHashAdd
 * keys are always strings and always copied
 */
adtHash adtHashNew(int initSize, int keysUpper, adtHashType  strings);

/* destroy hashtable, call freeVal on each val */
void adtHashFree(adtHash, void (*freeVal)(void*));

/* add pair key/val to hash, return old value */
void*	adtHashAdd(adtHash, char* key, void* val);

/* del key from hash, return old value */
void*	adtHashDel(adtHash, char* key);

/* return val for key in hash.  NULL if not found. */
void*	adtHashItem(adtHash, char* key);

/* iterator over keys in hash.  NextKeys returns NULL when no keys left. */
void	StartKeys(adtHash);
char*	NextKeys(adtHash);

int     adtHashSize(adtHash);

/*========================================================================
// set this adtMsgQ's trace flag ON or OFF*/
void	adtHashSetTraceFlag(adtHash,TRACE_FLAG);

/*========================================================================
 * adtHash Trace module
 *	!!! [Important]  
 *	!!!	Set tracer to NULL before you call TCREnd(). 
 *
 * 	TCR trace level 0 : log nothing 
 *	TCR trace level 1 : log errors only
 *	TCR trace level 2 : log all detial records
 */
void		adtHashSetTracer(TCR tracer);

TCR		adtHashGetTracer(void);

#ifdef  __cplusplus
}
#endif

#endif /* ADTHASH_H */
