// SimRTPDlg.cpp : implementation file
//

#include "stdafx.h"
#include "SimRTP.h"
#include "SimRTPDlg.h"
#include "cclRtp.c"
//#include "WavInOut.cpp"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

char IP[100];

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSimRTPDlg dialog

static CSimRTPDlg* csimrtpdlg = NULL;

CSimRTPDlg::CSimRTPDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSimRTPDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSimRTPDlg)
	csimrtpdlg = this;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	

	//cclRTPStartup add here

	m_RtpChan=0;

	m_BufRTP2IO=adtBufferNew(4096);
	m_BufIO2RTP=adtBufferNew(4096);
	m_WaveIOObj = WavInOut::instance();
	m_WaveIOObj->init(Wav2RTP,RTP2Wav);
	//RTPOpenPort add here

	m_bUDP=TRUE;
	m_bTCP=FALSE;
	m_bCallAuto=TRUE;
	m_flag = TRUE;
}

void CSimRTPDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSimRTPDlg)
	DDX_Control(pDX, IDOK, m_OK);
	DDX_Control(pDX, IDC_EDIT1, m_IP_CTL);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSimRTPDlg, CDialog)
	//{{AFX_MSG_MAP(CSimRTPDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_EN_CHANGE(IDC_EDIT1, OnChangeEdit1)
	
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSimRTPDlg message handlers

BOOL CSimRTPDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
		
	// TODO: Add extra initialization here
	m_IP_CTL.SetFocus();
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CSimRTPDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CSimRTPDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CSimRTPDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CSimRTPDlg::OnCancel() 
{
	// TODO: Add extra cleanup here
	m_WaveIOObj->stopPlaying();
	m_WaveIOObj->stopRecording();

	if(m_WaveIOObj->isWavInOpen)	m_WaveIOObj->wavInClose();
	if(m_WaveIOObj->isWavOutOpen)	m_WaveIOObj->wavOutClose();
	
	CDialog::OnCancel();
}

void CSimRTPDlg::OnChangeEdit1() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here

}

void CSimRTPDlg::OnOK() 
{
	// TODO: Add extra validation here
	
	//CDialog::OnOK();
	int t;
	
	t = m_IP_CTL.GetWindowText(IP, 100);

	//int mediaType=m_SdpObj.SdpGetAudioType();
	//int format=CheckMediaSupport(mediaType);
	//UA_WAV_PCMU = 0x0001,
	//UA_WAV_PCMA = 0x0010,
	//UA_WAV_GSM =  0x0100
	//typedef enum {
	//WAV_PCMU = 0x0,
	//WAV_PCMA = 0x8,
	//WAV_GSM = 0x3
	//} WAV_FORMATE;
	WAV_FORMATE wavetype= WAV_PCMU;

	m_WaveIOObj->stopPlaying();
	m_WaveIOObj->stopRecording();

	if(m_WaveIOObj->isWavInOpen)	m_WaveIOObj->wavInClose();
	if(m_WaveIOObj->isWavOutOpen)	m_WaveIOObj->wavOutClose();
	
	if( TRUE == m_flag ) {
		m_flag = FALSE;
		m_OK.SetWindowText("_");
		//RTPPeerConnect add here, assign target ip and port here.

		adtBufferClear(m_BufRTP2IO);
		adtBufferClear(m_BufIO2RTP);
		if(m_WaveIOObj->wavInOpen(wavetype,8,8000,1,30)!=0)
			m_IP_CTL.SetWindowText("Open WaveIO Error!");
		else if ( m_WaveIOObj->startRecording()!=0 )
			m_IP_CTL.SetWindowText("Record Error!");

		if(m_WaveIOObj->wavOutOpen(wavetype,8,8000,1,30)!=0)
			m_IP_CTL.SetWindowText("Open WaveOut Error!");
		else if ( m_WaveIOObj->startPlaying()!=0 )
			m_IP_CTL.SetWindowText("Playing Error!");
	}
	else {
		m_flag = TRUE;
		m_OK.SetWindowText("su");
	}
}

int CSimRTPDlg::RTPEventHandler(int channel,const char* buffer,int buflen)
{
	return adtBufferWrite(csimrtpdlg->m_BufRTP2IO,((char *) buffer),buflen);
}

int CSimRTPDlg::Wav2RTP(char* buff, int len)
{
	char buffer[1024];

	int xlen=0;

	memcpy(buffer,buff,len);
	xlen = cclRTPWrite(csimrtpdlg->m_RtpChan,buffer,len);
	return (xlen>=len)?len:xlen;
}

int CSimRTPDlg::RTP2Wav(char* buff, int len)
{
	return adtBufferRead(csimrtpdlg->m_BufRTP2IO,buff,len);
}

int CSimRTPDlg::MediaConnection()
{
	return 0;
}

int CSimRTPDlg::MediaPlayTone()
{
	return 0;
}

int CSimRTPDlg::Media_RTP_Stop()
{
	m_WaveIOObj->stopPlaying();
	m_WaveIOObj->stopRecording();

	adtBufferClear(m_BufRTP2IO);
	adtBufferClear(m_BufIO2RTP);
	if(m_WaveIOObj->isWavInOpen)	m_WaveIOObj->wavInClose();
	if(m_WaveIOObj->isWavOutOpen)	m_WaveIOObj->wavOutClose();

	cclRTPClose(m_RtpChan);

	adtBufferClear(m_BufRTP2IO);
	adtBufferClear(m_BufIO2RTP);

	return 0;
}
int CSimRTPDlg::RTPOpenPort()
{
	int result=0;

	result=cclRTPOpen(m_RtpChan,240); /*240 = packet size */

	return result;
}

int CSimRTPDlg::RTPPeerConnect(CString ip,int port)
{
	CString buf;
	buf.Format("[RTP] Open Peer RTP: IP(%s),Port(%d)\n",ip,port);
	RTPOpenPort();

	cclRTPSetPeerAddr(m_RtpChan,(LPSTR)(LPCSTR)ip,port);
	buf.Format("[RTP] Get had open RTP listen Port (%d)\n",cclRTPGetPort(m_RtpChan));

	cclRTPSetEventHandler(RTPEventHandler); /*set event handler */

	return 0;
}

