/* 
 * Copyright (C) 2000-2001 Computer & Communications Research Laboratories,
 *			   Industrial Technology Research Institute
 */
/*
 * msgEvent.h
 *
 * $Id: msgEvent.h,v 1.8 2001/06/15 08:14:10 sjtsai Exp $
 */

#ifndef MSGEVENT_H 
#define MSGEVENT_H

#ifdef  __cplusplus
extern "C" {
#endif

#include "msgSock.h"
#include "tracer.h"

typedef struct msgEventObj	*msgEvent;

typedef enum 
{
	msgEventUnknown=0,
	msgEventRd=0x01,
	msgEventWr=0x02,
	msgEventEx=0x04
} msgEventType;

typedef void (*msgEventCB)(msgSock sock, msgEventType event, int err, void* context);

msgEvent	msgEventNew(void);
void		msgEventFree(msgEvent);
int		msgEventRegister(msgEvent, msgSock, msgEventType, msgEventCB, void* context);
int		msgEventUnregister(msgEvent, msgSock);
int		msgEventDispatch(msgEvent, int timeout/*msec; -1 for blocking*/);

/*========================================================================
 * msgEvent Trace module
 *	!!! [Important]  
 *	!!!	Set tracer to NULL before you call TCREnd(). 
 *
 * 	TCR trace level 0 : log nothing 
 *	TCR trace level 1 : log errors only
 *	TCR trace level 2 : log all detial records
 */
void	msgEventSetTracer(TCR tracer);

TCR	msgEventGetTracer(void);

#ifdef  __cplusplus
}
#endif

#endif /* MSGEVENT_H */
