#!/bin/bash
DIR=data
mkdir $DIR 2> /dev/null

if [ ! -d "$DIR/documents" ]; then
    if [ ! -f "$DIR/wiki10+_documents.tar.bz2" ]; then
        echo "Downloading documents..."
        wget -O "$DIR/wiki10+_documents.tar.bz2" https://www.zubiaga.org/datasets/wiki10+/wiki10+_documents.tar.bz2
    fi
    echo "Extracting documents..."
    tar -jxf "$DIR/wiki10+_documents.tar.bz2" -C $DIR
else
    echo "Documents already exists."
fi

if [ ! -f "$DIR/tag-data.xml" ]; then
    if [ ! -f "$DIR/wiki10+_tag-data.tar.gz" ]; then
        echo "Downloading tag data..."
        wget -O "$DIR/wiki10+_tag-data.tar.gz" https://www.zubiaga.org/datasets/wiki10+/wiki10+_tag-data.tar.gz
    fi
    echo "Extracting tag data..."
    tar -zxf "$DIR/wiki10+_tag-data.tar.gz" -C $DIR
else
    echo "Tag data already exists."
fi