#include "lib0913.h"
#include <algorithm>
#include <bit>
#include <iostream>
#include <random>
#include <utility>
#include <vector>

int main() {
  int t;
  uint32_t seed;
  std::cin >> t >> seed;
  while (t--) {
    int n;
    std::cin >> n;

    Init(n);

    std::vector<std::vector<int>> g(n);
    std::vector<int> p(n);
    for (int i = 1; i < n; ++i) {
      std::cin >> p[i];
      p[i] -= 1;
      g[p[i]].push_back(i);
    }

    int order = 1;
    std::vector<int> pre_order(n), ending(n);
    auto DfsPreOrder = [&](auto self, int u) -> void {
      pre_order[u] = order++;
      for (int v : g[u]) {
        self(self, v);
      }
      ending[u] = order;
    };
    DfsPreOrder(DfsPreOrder, 0);

    std::vector<int> strength(n);

    std::mt19937 rng(seed);
    std::vector<int> query_order(n);
    std::iota(query_order.begin(), query_order.end(), 0);
    std::shuffle(query_order.begin(), query_order.end(), rng);
    for (int u : query_order) {
      std::vector<int> nearby;
      for (int v : g[u]) {
        nearby.push_back(pre_order[v]);
      }
      if (u != 0) {
        nearby.push_back(pre_order[p[u]]);
      }

      strength[u] = GetId(pre_order[u], nearby);
    }

    auto UpdateStrength = [&](auto self, int u) -> void {
      for (int v : g[u]) {
        self(self, v);
        strength[u] = std::max(strength[u], strength[v]);
      }
    };
    UpdateStrength(UpdateStrength, 0);

    std::vector<int> edge_color(n, 1);
    auto UpdateEdgeColor = [&](auto self, int u) -> void {
      std::vector<int> good_children;
      for (int v : g[u]) {
        self(self, v);
        if (strength[v] == strength[u]) {
          good_children.emplace_back(v);
        }
      }

      if (!good_children.empty()) {
        int ch = rng() % (int)good_children.size();
        edge_color[good_children[ch]] = 0;
      }
    };
    UpdateEdgeColor(UpdateEdgeColor, 0);

    auto IsAncestor = [&](int u, int v) {
      return pre_order[u] <= pre_order[v] && ending[v] <= ending[u];
    };

    const int limit = 2 * std::__lg(n);
    for (int i = 0; i < n; ++i) {
      for (int j = i + 1; j < n; ++j) {
        int black_edges = 0;

        int u = i, v = j;
        for (; !IsAncestor(u, v); u = p[u]) {
          black_edges += edge_color[u];
        }
        for (; !IsAncestor(v, u); v = p[v]) {
          black_edges += edge_color[v];
        }

        if (black_edges > limit) {
          std::cout << "Wrong answer: " << i + 1 << " to " << j + 1 << " passes "
                    << black_edges << " black edges, limit = " << limit << ".\n";
          return 0;
        }
      }
    }
    std::cout << "Accepted\n";
  }
  return 0;
}
